# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import RecordingLocation

class RecordingRoadsideAssistance(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        RecordingRoadsideAssistance - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'text': 'str',
            'phone_number': 'str',
            'is_device_phone_number': 'bool',
            'location': 'RecordingLocation',
            'message_number': 'int'
        }

        self.attribute_map = {
            'text': 'text',
            'phone_number': 'phoneNumber',
            'is_device_phone_number': 'isDevicePhoneNumber',
            'location': 'location',
            'message_number': 'messageNumber'
        }

        self._text = None
        self._phone_number = None
        self._is_device_phone_number = None
        self._location = None
        self._message_number = None

    @property
    def text(self) -> str:
        """
        Gets the text of this RecordingRoadsideAssistance.
        The Roadside Assistance message text.

        :return: The text of this RecordingRoadsideAssistance.
        :rtype: str
        """
        return self._text

    @text.setter
    def text(self, text: str) -> None:
        """
        Sets the text of this RecordingRoadsideAssistance.
        The Roadside Assistance message text.

        :param text: The text of this RecordingRoadsideAssistance.
        :type: str
        """
        

        self._text = text

    @property
    def phone_number(self) -> str:
        """
        Gets the phone_number of this RecordingRoadsideAssistance.
        Phone number the user provided.

        :return: The phone_number of this RecordingRoadsideAssistance.
        :rtype: str
        """
        return self._phone_number

    @phone_number.setter
    def phone_number(self, phone_number: str) -> None:
        """
        Sets the phone_number of this RecordingRoadsideAssistance.
        Phone number the user provided.

        :param phone_number: The phone_number of this RecordingRoadsideAssistance.
        :type: str
        """
        

        self._phone_number = phone_number

    @property
    def is_device_phone_number(self) -> bool:
        """
        Gets the is_device_phone_number of this RecordingRoadsideAssistance.
        If the user provided their own phone number.

        :return: The is_device_phone_number of this RecordingRoadsideAssistance.
        :rtype: bool
        """
        return self._is_device_phone_number

    @is_device_phone_number.setter
    def is_device_phone_number(self, is_device_phone_number: bool) -> None:
        """
        Sets the is_device_phone_number of this RecordingRoadsideAssistance.
        If the user provided their own phone number.

        :param is_device_phone_number: The is_device_phone_number of this RecordingRoadsideAssistance.
        :type: bool
        """
        

        self._is_device_phone_number = is_device_phone_number

    @property
    def location(self) -> 'RecordingLocation':
        """
        Gets the location of this RecordingRoadsideAssistance.
        User Location object.

        :return: The location of this RecordingRoadsideAssistance.
        :rtype: RecordingLocation
        """
        return self._location

    @location.setter
    def location(self, location: 'RecordingLocation') -> None:
        """
        Sets the location of this RecordingRoadsideAssistance.
        User Location object.

        :param location: The location of this RecordingRoadsideAssistance.
        :type: RecordingLocation
        """
        

        self._location = location

    @property
    def message_number(self) -> int:
        """
        Gets the message_number of this RecordingRoadsideAssistance.
        The counter of the message.

        :return: The message_number of this RecordingRoadsideAssistance.
        :rtype: int
        """
        return self._message_number

    @message_number.setter
    def message_number(self, message_number: int) -> None:
        """
        Sets the message_number of this RecordingRoadsideAssistance.
        The counter of the message.

        :param message_number: The message_number of this RecordingRoadsideAssistance.
        :type: int
        """
        

        self._message_number = message_number

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

