# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import AddressableEntityRef

class ReprocessJobResponse(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        ReprocessJobResponse - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'description': 'str',
            'date_start': 'datetime',
            'date_end': 'datetime',
            'media_types': 'list[str]',
            'programs': 'list[str]',
            'dialects': 'list[str]',
            'created_by': 'AddressableEntityRef',
            'date_created': 'datetime',
            'job_status': 'str',
            'queue_order': 'int',
            'processed_interactions_count': 'int',
            'failed_interactions_count': 'int',
            'total_interactions_count': 'int',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'description': 'description',
            'date_start': 'dateStart',
            'date_end': 'dateEnd',
            'media_types': 'mediaTypes',
            'programs': 'programs',
            'dialects': 'dialects',
            'created_by': 'createdBy',
            'date_created': 'dateCreated',
            'job_status': 'jobStatus',
            'queue_order': 'queueOrder',
            'processed_interactions_count': 'processedInteractionsCount',
            'failed_interactions_count': 'failedInteractionsCount',
            'total_interactions_count': 'totalInteractionsCount',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._description = None
        self._date_start = None
        self._date_end = None
        self._media_types = None
        self._programs = None
        self._dialects = None
        self._created_by = None
        self._date_created = None
        self._job_status = None
        self._queue_order = None
        self._processed_interactions_count = None
        self._failed_interactions_count = None
        self._total_interactions_count = None
        self._self_uri = None

    @property
    def id(self) -> str:
        """
        Gets the id of this ReprocessJobResponse.
        The globally unique identifier for the object.

        :return: The id of this ReprocessJobResponse.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this ReprocessJobResponse.
        The globally unique identifier for the object.

        :param id: The id of this ReprocessJobResponse.
        :type: str
        """
        

        self._id = id

    @property
    def name(self) -> str:
        """
        Gets the name of this ReprocessJobResponse.


        :return: The name of this ReprocessJobResponse.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str) -> None:
        """
        Sets the name of this ReprocessJobResponse.


        :param name: The name of this ReprocessJobResponse.
        :type: str
        """
        

        self._name = name

    @property
    def description(self) -> str:
        """
        Gets the description of this ReprocessJobResponse.
        The description of the job.

        :return: The description of this ReprocessJobResponse.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description: str) -> None:
        """
        Sets the description of this ReprocessJobResponse.
        The description of the job.

        :param description: The description of this ReprocessJobResponse.
        :type: str
        """
        

        self._description = description

    @property
    def date_start(self) -> datetime:
        """
        Gets the date_start of this ReprocessJobResponse.
        The date from which the reprocessing should begin. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_start of this ReprocessJobResponse.
        :rtype: datetime
        """
        return self._date_start

    @date_start.setter
    def date_start(self, date_start: datetime) -> None:
        """
        Sets the date_start of this ReprocessJobResponse.
        The date from which the reprocessing should begin. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_start: The date_start of this ReprocessJobResponse.
        :type: datetime
        """
        

        self._date_start = date_start

    @property
    def date_end(self) -> datetime:
        """
        Gets the date_end of this ReprocessJobResponse.
        The date at which the reprocessing should end. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_end of this ReprocessJobResponse.
        :rtype: datetime
        """
        return self._date_end

    @date_end.setter
    def date_end(self, date_end: datetime) -> None:
        """
        Sets the date_end of this ReprocessJobResponse.
        The date at which the reprocessing should end. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_end: The date_end of this ReprocessJobResponse.
        :type: datetime
        """
        

        self._date_end = date_end

    @property
    def media_types(self) -> List[str]:
        """
        Gets the media_types of this ReprocessJobResponse.
        Media types used to filter interactions.

        :return: The media_types of this ReprocessJobResponse.
        :rtype: list[str]
        """
        return self._media_types

    @media_types.setter
    def media_types(self, media_types: List[str]) -> None:
        """
        Sets the media_types of this ReprocessJobResponse.
        Media types used to filter interactions.

        :param media_types: The media_types of this ReprocessJobResponse.
        :type: list[str]
        """
        

        self._media_types = media_types

    @property
    def programs(self) -> List[str]:
        """
        Gets the programs of this ReprocessJobResponse.
        The mapped programs to be included in the job.

        :return: The programs of this ReprocessJobResponse.
        :rtype: list[str]
        """
        return self._programs

    @programs.setter
    def programs(self, programs: List[str]) -> None:
        """
        Sets the programs of this ReprocessJobResponse.
        The mapped programs to be included in the job.

        :param programs: The programs of this ReprocessJobResponse.
        :type: list[str]
        """
        

        self._programs = programs

    @property
    def dialects(self) -> List[str]:
        """
        Gets the dialects of this ReprocessJobResponse.
        Language dialects used to filter interactions.

        :return: The dialects of this ReprocessJobResponse.
        :rtype: list[str]
        """
        return self._dialects

    @dialects.setter
    def dialects(self, dialects: List[str]) -> None:
        """
        Sets the dialects of this ReprocessJobResponse.
        Language dialects used to filter interactions.

        :param dialects: The dialects of this ReprocessJobResponse.
        :type: list[str]
        """
        

        self._dialects = dialects

    @property
    def created_by(self) -> 'AddressableEntityRef':
        """
        Gets the created_by of this ReprocessJobResponse.
        The user who created the job.

        :return: The created_by of this ReprocessJobResponse.
        :rtype: AddressableEntityRef
        """
        return self._created_by

    @created_by.setter
    def created_by(self, created_by: 'AddressableEntityRef') -> None:
        """
        Sets the created_by of this ReprocessJobResponse.
        The user who created the job.

        :param created_by: The created_by of this ReprocessJobResponse.
        :type: AddressableEntityRef
        """
        

        self._created_by = created_by

    @property
    def date_created(self) -> datetime:
        """
        Gets the date_created of this ReprocessJobResponse.
        The date the job was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_created of this ReprocessJobResponse.
        :rtype: datetime
        """
        return self._date_created

    @date_created.setter
    def date_created(self, date_created: datetime) -> None:
        """
        Sets the date_created of this ReprocessJobResponse.
        The date the job was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_created: The date_created of this ReprocessJobResponse.
        :type: datetime
        """
        

        self._date_created = date_created

    @property
    def job_status(self) -> str:
        """
        Gets the job_status of this ReprocessJobResponse.
        The status of the job.

        :return: The job_status of this ReprocessJobResponse.
        :rtype: str
        """
        return self._job_status

    @job_status.setter
    def job_status(self, job_status: str) -> None:
        """
        Sets the job_status of this ReprocessJobResponse.
        The status of the job.

        :param job_status: The job_status of this ReprocessJobResponse.
        :type: str
        """
        if isinstance(job_status, int):
            job_status = str(job_status)
        allowed_values = ["Queued", "InProgress", "Completed", "Failed"]
        if job_status.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for job_status -> " + job_status)
            self._job_status = "outdated_sdk_version"
        else:
            self._job_status = job_status

    @property
    def queue_order(self) -> int:
        """
        Gets the queue_order of this ReprocessJobResponse.
        The position of the job in the queued jobs.

        :return: The queue_order of this ReprocessJobResponse.
        :rtype: int
        """
        return self._queue_order

    @queue_order.setter
    def queue_order(self, queue_order: int) -> None:
        """
        Sets the queue_order of this ReprocessJobResponse.
        The position of the job in the queued jobs.

        :param queue_order: The queue_order of this ReprocessJobResponse.
        :type: int
        """
        

        self._queue_order = queue_order

    @property
    def processed_interactions_count(self) -> int:
        """
        Gets the processed_interactions_count of this ReprocessJobResponse.
        The amount of interactions successfully reprocessed.

        :return: The processed_interactions_count of this ReprocessJobResponse.
        :rtype: int
        """
        return self._processed_interactions_count

    @processed_interactions_count.setter
    def processed_interactions_count(self, processed_interactions_count: int) -> None:
        """
        Sets the processed_interactions_count of this ReprocessJobResponse.
        The amount of interactions successfully reprocessed.

        :param processed_interactions_count: The processed_interactions_count of this ReprocessJobResponse.
        :type: int
        """
        

        self._processed_interactions_count = processed_interactions_count

    @property
    def failed_interactions_count(self) -> int:
        """
        Gets the failed_interactions_count of this ReprocessJobResponse.
        The amount of failed interactions.

        :return: The failed_interactions_count of this ReprocessJobResponse.
        :rtype: int
        """
        return self._failed_interactions_count

    @failed_interactions_count.setter
    def failed_interactions_count(self, failed_interactions_count: int) -> None:
        """
        Sets the failed_interactions_count of this ReprocessJobResponse.
        The amount of failed interactions.

        :param failed_interactions_count: The failed_interactions_count of this ReprocessJobResponse.
        :type: int
        """
        

        self._failed_interactions_count = failed_interactions_count

    @property
    def total_interactions_count(self) -> int:
        """
        Gets the total_interactions_count of this ReprocessJobResponse.
        The amount of interactions in the job.

        :return: The total_interactions_count of this ReprocessJobResponse.
        :rtype: int
        """
        return self._total_interactions_count

    @total_interactions_count.setter
    def total_interactions_count(self, total_interactions_count: int) -> None:
        """
        Sets the total_interactions_count of this ReprocessJobResponse.
        The amount of interactions in the job.

        :param total_interactions_count: The total_interactions_count of this ReprocessJobResponse.
        :type: int
        """
        

        self._total_interactions_count = total_interactions_count

    @property
    def self_uri(self) -> str:
        """
        Gets the self_uri of this ReprocessJobResponse.
        The URI for this object

        :return: The self_uri of this ReprocessJobResponse.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri: str) -> None:
        """
        Sets the self_uri of this ReprocessJobResponse.
        The URI for this object

        :param self_uri: The self_uri of this ReprocessJobResponse.
        :type: str
        """
        

        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

