# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class RowSearchPredicate(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        RowSearchPredicate - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'column_id': 'str',
            'operator': 'str',
            'value': 'str',
            'special': 'str'
        }

        self.attribute_map = {
            'column_id': 'columnId',
            'operator': 'operator',
            'value': 'value',
            'special': 'special'
        }

        self._column_id = None
        self._operator = None
        self._value = None
        self._special = None

    @property
    def column_id(self) -> str:
        """
        Gets the column_id of this RowSearchPredicate.
        The decision table column identifier this predicate applies to

        :return: The column_id of this RowSearchPredicate.
        :rtype: str
        """
        return self._column_id

    @column_id.setter
    def column_id(self, column_id: str) -> None:
        """
        Sets the column_id of this RowSearchPredicate.
        The decision table column identifier this predicate applies to

        :param column_id: The column_id of this RowSearchPredicate.
        :type: str
        """
        

        self._column_id = column_id

    @property
    def operator(self) -> str:
        """
        Gets the operator of this RowSearchPredicate.
        The search operator for this predicate

        :return: The operator of this RowSearchPredicate.
        :rtype: str
        """
        return self._operator

    @operator.setter
    def operator(self, operator: str) -> None:
        """
        Sets the operator of this RowSearchPredicate.
        The search operator for this predicate

        :param operator: The operator of this RowSearchPredicate.
        :type: str
        """
        if isinstance(operator, int):
            operator = str(operator)
        allowed_values = ["Equals", "StartsWith", "GreaterThan", "GreaterThanOrEquals", "LessThan", "LessThanOrEquals"]
        if operator.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for operator -> " + operator)
            self._operator = "outdated_sdk_version"
        else:
            self._operator = operator

    @property
    def value(self) -> str:
        """
        Gets the value of this RowSearchPredicate.
        The value that will be searched for in rows. Exactly one of 'value' or 'special' can be used.

        :return: The value of this RowSearchPredicate.
        :rtype: str
        """
        return self._value

    @value.setter
    def value(self, value: str) -> None:
        """
        Sets the value of this RowSearchPredicate.
        The value that will be searched for in rows. Exactly one of 'value' or 'special' can be used.

        :param value: The value of this RowSearchPredicate.
        :type: str
        """
        
        if len(value) > 200:
            raise ValueError("Invalid value for `value`, length must be less than `200`")

        if len(value) < 1:
            raise ValueError("Invalid value for `value`, length must be greater than or equal to `1`")


        self._value = value

    @property
    def special(self) -> str:
        """
        Gets the special of this RowSearchPredicate.
        The special value that will be searched for in rows. Exactly one of 'value' or 'special' can be used.

        :return: The special of this RowSearchPredicate.
        :rtype: str
        """
        return self._special

    @special.setter
    def special(self, special: str) -> None:
        """
        Sets the special of this RowSearchPredicate.
        The special value that will be searched for in rows. Exactly one of 'value' or 'special' can be used.

        :param special: The special of this RowSearchPredicate.
        :type: str
        """
        if isinstance(special, int):
            special = str(special)
        allowed_values = ["Wildcard", "Null", "Empty", "CurrentTime"]
        if special.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for special -> " + special)
            self._special = "outdated_sdk_version"
        else:
            self._special = special

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

