# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class ScheduleGenerationWarning(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        ScheduleGenerationWarning - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'user_id': 'str',
            'user_not_licensed': 'bool',
            'unable_to_meet_max_days': 'bool',
            'unable_to_schedule_required_days': 'list[str]',
            'unable_to_meet_min_paid_for_the_week': 'bool',
            'unable_to_meet_max_paid_for_the_week': 'bool',
            'no_need_days': 'list[str]',
            'shifts_too_close_together': 'bool'
        }

        self.attribute_map = {
            'user_id': 'userId',
            'user_not_licensed': 'userNotLicensed',
            'unable_to_meet_max_days': 'unableToMeetMaxDays',
            'unable_to_schedule_required_days': 'unableToScheduleRequiredDays',
            'unable_to_meet_min_paid_for_the_week': 'unableToMeetMinPaidForTheWeek',
            'unable_to_meet_max_paid_for_the_week': 'unableToMeetMaxPaidForTheWeek',
            'no_need_days': 'noNeedDays',
            'shifts_too_close_together': 'shiftsTooCloseTogether'
        }

        self._user_id = None
        self._user_not_licensed = None
        self._unable_to_meet_max_days = None
        self._unable_to_schedule_required_days = None
        self._unable_to_meet_min_paid_for_the_week = None
        self._unable_to_meet_max_paid_for_the_week = None
        self._no_need_days = None
        self._shifts_too_close_together = None

    @property
    def user_id(self) -> str:
        """
        Gets the user_id of this ScheduleGenerationWarning.
        ID of the user in the warning

        :return: The user_id of this ScheduleGenerationWarning.
        :rtype: str
        """
        return self._user_id

    @user_id.setter
    def user_id(self, user_id: str) -> None:
        """
        Sets the user_id of this ScheduleGenerationWarning.
        ID of the user in the warning

        :param user_id: The user_id of this ScheduleGenerationWarning.
        :type: str
        """
        

        self._user_id = user_id

    @property
    def user_not_licensed(self) -> bool:
        """
        Gets the user_not_licensed of this ScheduleGenerationWarning.
        Whether the user does not have the appropriate license to be scheduled

        :return: The user_not_licensed of this ScheduleGenerationWarning.
        :rtype: bool
        """
        return self._user_not_licensed

    @user_not_licensed.setter
    def user_not_licensed(self, user_not_licensed: bool) -> None:
        """
        Sets the user_not_licensed of this ScheduleGenerationWarning.
        Whether the user does not have the appropriate license to be scheduled

        :param user_not_licensed: The user_not_licensed of this ScheduleGenerationWarning.
        :type: bool
        """
        

        self._user_not_licensed = user_not_licensed

    @property
    def unable_to_meet_max_days(self) -> bool:
        """
        Gets the unable_to_meet_max_days of this ScheduleGenerationWarning.
        Whether the number of scheduled days exceeded the maximum days to schedule defined in the agent work plan

        :return: The unable_to_meet_max_days of this ScheduleGenerationWarning.
        :rtype: bool
        """
        return self._unable_to_meet_max_days

    @unable_to_meet_max_days.setter
    def unable_to_meet_max_days(self, unable_to_meet_max_days: bool) -> None:
        """
        Sets the unable_to_meet_max_days of this ScheduleGenerationWarning.
        Whether the number of scheduled days exceeded the maximum days to schedule defined in the agent work plan

        :param unable_to_meet_max_days: The unable_to_meet_max_days of this ScheduleGenerationWarning.
        :type: bool
        """
        

        self._unable_to_meet_max_days = unable_to_meet_max_days

    @property
    def unable_to_schedule_required_days(self) -> List[str]:
        """
        Gets the unable_to_schedule_required_days of this ScheduleGenerationWarning.
        Days indicated as required to work in agent work plan where no viable shift was found to schedule

        :return: The unable_to_schedule_required_days of this ScheduleGenerationWarning.
        :rtype: list[str]
        """
        return self._unable_to_schedule_required_days

    @unable_to_schedule_required_days.setter
    def unable_to_schedule_required_days(self, unable_to_schedule_required_days: List[str]) -> None:
        """
        Sets the unable_to_schedule_required_days of this ScheduleGenerationWarning.
        Days indicated as required to work in agent work plan where no viable shift was found to schedule

        :param unable_to_schedule_required_days: The unable_to_schedule_required_days of this ScheduleGenerationWarning.
        :type: list[str]
        """
        

        self._unable_to_schedule_required_days = unable_to_schedule_required_days

    @property
    def unable_to_meet_min_paid_for_the_week(self) -> bool:
        """
        Gets the unable_to_meet_min_paid_for_the_week of this ScheduleGenerationWarning.
        Whether the schedule did not meet the minimum paid time for the week defined in the agent work plan

        :return: The unable_to_meet_min_paid_for_the_week of this ScheduleGenerationWarning.
        :rtype: bool
        """
        return self._unable_to_meet_min_paid_for_the_week

    @unable_to_meet_min_paid_for_the_week.setter
    def unable_to_meet_min_paid_for_the_week(self, unable_to_meet_min_paid_for_the_week: bool) -> None:
        """
        Sets the unable_to_meet_min_paid_for_the_week of this ScheduleGenerationWarning.
        Whether the schedule did not meet the minimum paid time for the week defined in the agent work plan

        :param unable_to_meet_min_paid_for_the_week: The unable_to_meet_min_paid_for_the_week of this ScheduleGenerationWarning.
        :type: bool
        """
        

        self._unable_to_meet_min_paid_for_the_week = unable_to_meet_min_paid_for_the_week

    @property
    def unable_to_meet_max_paid_for_the_week(self) -> bool:
        """
        Gets the unable_to_meet_max_paid_for_the_week of this ScheduleGenerationWarning.
        Whether the schedule exceeded the maximum paid time for the week defined in the agent work plan

        :return: The unable_to_meet_max_paid_for_the_week of this ScheduleGenerationWarning.
        :rtype: bool
        """
        return self._unable_to_meet_max_paid_for_the_week

    @unable_to_meet_max_paid_for_the_week.setter
    def unable_to_meet_max_paid_for_the_week(self, unable_to_meet_max_paid_for_the_week: bool) -> None:
        """
        Sets the unable_to_meet_max_paid_for_the_week of this ScheduleGenerationWarning.
        Whether the schedule exceeded the maximum paid time for the week defined in the agent work plan

        :param unable_to_meet_max_paid_for_the_week: The unable_to_meet_max_paid_for_the_week of this ScheduleGenerationWarning.
        :type: bool
        """
        

        self._unable_to_meet_max_paid_for_the_week = unable_to_meet_max_paid_for_the_week

    @property
    def no_need_days(self) -> List[str]:
        """
        Gets the no_need_days of this ScheduleGenerationWarning.
        Days agent was scheduled but there was no need to meet. The scheduled days have no effect on service levels

        :return: The no_need_days of this ScheduleGenerationWarning.
        :rtype: list[str]
        """
        return self._no_need_days

    @no_need_days.setter
    def no_need_days(self, no_need_days: List[str]) -> None:
        """
        Sets the no_need_days of this ScheduleGenerationWarning.
        Days agent was scheduled but there was no need to meet. The scheduled days have no effect on service levels

        :param no_need_days: The no_need_days of this ScheduleGenerationWarning.
        :type: list[str]
        """
        

        self._no_need_days = no_need_days

    @property
    def shifts_too_close_together(self) -> bool:
        """
        Gets the shifts_too_close_together of this ScheduleGenerationWarning.
        Whether the schedule did not meet the minimum time between shifts defined in the agent work plan

        :return: The shifts_too_close_together of this ScheduleGenerationWarning.
        :rtype: bool
        """
        return self._shifts_too_close_together

    @shifts_too_close_together.setter
    def shifts_too_close_together(self, shifts_too_close_together: bool) -> None:
        """
        Sets the shifts_too_close_together of this ScheduleGenerationWarning.
        Whether the schedule did not meet the minimum time between shifts defined in the agent work plan

        :param shifts_too_close_together: The shifts_too_close_together of this ScheduleGenerationWarning.
        :type: bool
        """
        

        self._shifts_too_close_together = shifts_too_close_together

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

