# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class SchedulerMessageTypeSeverity(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        SchedulerMessageTypeSeverity - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'type': 'str',
            'severity': 'str'
        }

        self.attribute_map = {
            'type': 'type',
            'severity': 'severity'
        }

        self._type = None
        self._severity = None

    @property
    def type(self) -> str:
        """
        Gets the type of this SchedulerMessageTypeSeverity.
        The type of the message

        :return: The type of this SchedulerMessageTypeSeverity.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type: str) -> None:
        """
        Sets the type of this SchedulerMessageTypeSeverity.
        The type of the message

        :param type: The type of this SchedulerMessageTypeSeverity.
        :type: str
        """
        if isinstance(type, int):
            type = str(type)
        allowed_values = ["AgentNotFound", "AgentNotInSelectedManagementUnit", "AgentNotLicensed", "AgentWithoutWorkPlan", "WorkPlanNotEnabled", "WorkPlanNotFound", "AgentWithoutCapability", "NoNeedDays", "UnableToProduceAgentSchedule", "UnableToScheduleMaxConsecutiveWorkingDays", "UnableToScheduleMaxConsecutiveWorkingWeekends", "UnableToScheduleMaxWeeklyPaidTime", "UnableToScheduleMaxWeeklyWorkDays", "UnableToScheduleMaxWorkDayPaidTime", "UnableToScheduleMinConsecutiveNonWorkingTimePerWeek", "UnableToScheduleMinIntershiftTime", "UnableToScheduleMinShiftStartDistance", "UnableToScheduleMinWeeklyPaidTime", "UnableToScheduleMinWeeklyWorkDays", "UnableToScheduleMinWorkDayPaidTime", "UnableToSchedulePlanningPeriodMaxDaysOff", "UnableToSchedulePlanningPeriodMaxPaidTime", "UnableToSchedulePlanningPeriodMinDaysOff", "UnableToSchedulePlanningPeriodMinPaidTime", "UnableToScheduleShiftVariance", "UnableToScheduleWorkDay", "UnableToScheduleMaxConsecutiveWorkingDaysFromAgentHistory", "UnableToScheduleMaxConsecutiveWorkingWeekendsFromAgentHistory", "UnableToScheduleMaxWeeklyPaidTimeFromTimeOff", "UnableToScheduleMaxWorkDayPaidTimeFromTimeOff", "UnableToScheduleMinIntershiftTimeFromAgentHistory", "UnableToScheduleMinIntershiftTimeFromDst", "UnableToScheduleMinShiftStartDistanceFromAgentHistory", "UnableToScheduleMinShiftStartDistanceFromDst", "UnableToScheduleMinWeeklyPaidTimeFromTimeOff", "UnableToScheduleMinWeeklyWorkDaysFromTimeOff", "UnableToScheduleMinWorkDayPaidTimeFromTimeOff", "UnableToSchedulePlanningPeriodMaxDaysOffFromAgentHistory", "UnableToSchedulePlanningPeriodMaxDaysOffFromTimeOff", "UnableToSchedulePlanningPeriodMaxPaidTimeFromAgentHistory", "UnableToSchedulePlanningPeriodMaxPaidTimeFromTimeOff", "UnableToSchedulePlanningPeriodMinDaysOffFromAgentHistory", "UnableToSchedulePlanningPeriodMinPaidTimeFromAgentHistory", "UnableToSchedulePlanningPeriodMinPaidTimeFromTimeOff", "UnableToScheduleWorkDayFromTimeOff", "AgentWithoutCapabilityToHandleActivityOnQueueWork", "UnableToProduceAgentScheduleDueToUnavailableTimes", "UnableToSchedulePlanningPeriodMaxShiftStartTimeVarianceFromAgentHistory", "UnableToSchedulePlanningPeriodMaxWorkingWeekendsFromAgentHistory", "UnableToSchedulePlanningPeriodShiftMaxCountFromAgentHistory", "UnableToSchedulePlanningPeriodShiftMinCountFromAgentHistory"]
        if type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for type -> " + type)
            self._type = "outdated_sdk_version"
        else:
            self._type = type

    @property
    def severity(self) -> str:
        """
        Gets the severity of this SchedulerMessageTypeSeverity.
        The severity of the message

        :return: The severity of this SchedulerMessageTypeSeverity.
        :rtype: str
        """
        return self._severity

    @severity.setter
    def severity(self, severity: str) -> None:
        """
        Sets the severity of this SchedulerMessageTypeSeverity.
        The severity of the message

        :param severity: The severity of this SchedulerMessageTypeSeverity.
        :type: str
        """
        if isinstance(severity, int):
            severity = str(severity)
        allowed_values = ["Ignore", "Information", "Warning", "Error"]
        if severity.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for severity -> " + severity)
            self._severity = "outdated_sdk_version"
        else:
            self._severity = severity

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

