# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import SchedulingNoForecastOptionsRequest

class SchedulingOptionsRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        SchedulingOptionsRequest - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'no_forecast_options': 'SchedulingNoForecastOptionsRequest',
            'activity_smoothing_type': 'str',
            'induce_schedule_variability': 'bool'
        }

        self.attribute_map = {
            'no_forecast_options': 'noForecastOptions',
            'activity_smoothing_type': 'activitySmoothingType',
            'induce_schedule_variability': 'induceScheduleVariability'
        }

        self._no_forecast_options = None
        self._activity_smoothing_type = None
        self._induce_schedule_variability = None

    @property
    def no_forecast_options(self) -> 'SchedulingNoForecastOptionsRequest':
        """
        Gets the no_forecast_options of this SchedulingOptionsRequest.
        Schedule generation options to apply if no forecast is supplied

        :return: The no_forecast_options of this SchedulingOptionsRequest.
        :rtype: SchedulingNoForecastOptionsRequest
        """
        return self._no_forecast_options

    @no_forecast_options.setter
    def no_forecast_options(self, no_forecast_options: 'SchedulingNoForecastOptionsRequest') -> None:
        """
        Sets the no_forecast_options of this SchedulingOptionsRequest.
        Schedule generation options to apply if no forecast is supplied

        :param no_forecast_options: The no_forecast_options of this SchedulingOptionsRequest.
        :type: SchedulingNoForecastOptionsRequest
        """
        

        self._no_forecast_options = no_forecast_options

    @property
    def activity_smoothing_type(self) -> str:
        """
        Gets the activity_smoothing_type of this SchedulingOptionsRequest.
        Overrides the default BU level activity smoothing type for this schedule generation

        :return: The activity_smoothing_type of this SchedulingOptionsRequest.
        :rtype: str
        """
        return self._activity_smoothing_type

    @activity_smoothing_type.setter
    def activity_smoothing_type(self, activity_smoothing_type: str) -> None:
        """
        Sets the activity_smoothing_type of this SchedulingOptionsRequest.
        Overrides the default BU level activity smoothing type for this schedule generation

        :param activity_smoothing_type: The activity_smoothing_type of this SchedulingOptionsRequest.
        :type: str
        """
        if isinstance(activity_smoothing_type, int):
            activity_smoothing_type = str(activity_smoothing_type)
        allowed_values = ["ReduceConcurrentActivitiesAcrossBu", "ReduceConcurrentActivitiesAcrossMu", "ConsistentServiceLevel"]
        if activity_smoothing_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for activity_smoothing_type -> " + activity_smoothing_type)
            self._activity_smoothing_type = "outdated_sdk_version"
        else:
            self._activity_smoothing_type = activity_smoothing_type

    @property
    def induce_schedule_variability(self) -> bool:
        """
        Gets the induce_schedule_variability of this SchedulingOptionsRequest.
        Overrides the default BU level induce schedule variability setting for this schedule generation

        :return: The induce_schedule_variability of this SchedulingOptionsRequest.
        :rtype: bool
        """
        return self._induce_schedule_variability

    @induce_schedule_variability.setter
    def induce_schedule_variability(self, induce_schedule_variability: bool) -> None:
        """
        Sets the induce_schedule_variability of this SchedulingOptionsRequest.
        Overrides the default BU level induce schedule variability setting for this schedule generation

        :param induce_schedule_variability: The induce_schedule_variability of this SchedulingOptionsRequest.
        :type: bool
        """
        

        self._induce_schedule_variability = induce_schedule_variability

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

