# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import AddressableEntityRef

class SentimentFeedback(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        SentimentFeedback - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'phrase': 'str',
            'dialect': 'str',
            'feedback_value': 'str',
            'date_created': 'datetime',
            'created_by': 'AddressableEntityRef'
        }

        self.attribute_map = {
            'id': 'id',
            'phrase': 'phrase',
            'dialect': 'dialect',
            'feedback_value': 'feedbackValue',
            'date_created': 'dateCreated',
            'created_by': 'createdBy'
        }

        self._id = None
        self._phrase = None
        self._dialect = None
        self._feedback_value = None
        self._date_created = None
        self._created_by = None

    @property
    def id(self) -> str:
        """
        Gets the id of this SentimentFeedback.
        The globally unique identifier for the object.

        :return: The id of this SentimentFeedback.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this SentimentFeedback.
        The globally unique identifier for the object.

        :param id: The id of this SentimentFeedback.
        :type: str
        """
        

        self._id = id

    @property
    def phrase(self) -> str:
        """
        Gets the phrase of this SentimentFeedback.
        The phrase for which sentiment feedback is provided

        :return: The phrase of this SentimentFeedback.
        :rtype: str
        """
        return self._phrase

    @phrase.setter
    def phrase(self, phrase: str) -> None:
        """
        Sets the phrase of this SentimentFeedback.
        The phrase for which sentiment feedback is provided

        :param phrase: The phrase of this SentimentFeedback.
        :type: str
        """
        

        self._phrase = phrase

    @property
    def dialect(self) -> str:
        """
        Gets the dialect of this SentimentFeedback.
        The dialect for the given phrase, dialect format is {language}-{country} where language follows ISO 639-1 standard and country follows ISO 3166-1 alpha 2 standard

        :return: The dialect of this SentimentFeedback.
        :rtype: str
        """
        return self._dialect

    @dialect.setter
    def dialect(self, dialect: str) -> None:
        """
        Sets the dialect of this SentimentFeedback.
        The dialect for the given phrase, dialect format is {language}-{country} where language follows ISO 639-1 standard and country follows ISO 3166-1 alpha 2 standard

        :param dialect: The dialect of this SentimentFeedback.
        :type: str
        """
        

        self._dialect = dialect

    @property
    def feedback_value(self) -> str:
        """
        Gets the feedback_value of this SentimentFeedback.
        The sentiment feedback value for the given phrase

        :return: The feedback_value of this SentimentFeedback.
        :rtype: str
        """
        return self._feedback_value

    @feedback_value.setter
    def feedback_value(self, feedback_value: str) -> None:
        """
        Sets the feedback_value of this SentimentFeedback.
        The sentiment feedback value for the given phrase

        :param feedback_value: The feedback_value of this SentimentFeedback.
        :type: str
        """
        if isinstance(feedback_value, int):
            feedback_value = str(feedback_value)
        allowed_values = ["Neutral", "Positive", "Negative"]
        if feedback_value.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for feedback_value -> " + feedback_value)
            self._feedback_value = "outdated_sdk_version"
        else:
            self._feedback_value = feedback_value

    @property
    def date_created(self) -> datetime:
        """
        Gets the date_created of this SentimentFeedback.
        The Timestamp when sentiment feedback created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_created of this SentimentFeedback.
        :rtype: datetime
        """
        return self._date_created

    @date_created.setter
    def date_created(self, date_created: datetime) -> None:
        """
        Sets the date_created of this SentimentFeedback.
        The Timestamp when sentiment feedback created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_created: The date_created of this SentimentFeedback.
        :type: datetime
        """
        

        self._date_created = date_created

    @property
    def created_by(self) -> 'AddressableEntityRef':
        """
        Gets the created_by of this SentimentFeedback.
        The Id of user who created the sentiment feedback

        :return: The created_by of this SentimentFeedback.
        :rtype: AddressableEntityRef
        """
        return self._created_by

    @created_by.setter
    def created_by(self, created_by: 'AddressableEntityRef') -> None:
        """
        Sets the created_by of this SentimentFeedback.
        The Id of user who created the sentiment feedback

        :param created_by: The created_by of this SentimentFeedback.
        :type: AddressableEntityRef
        """
        

        self._created_by = created_by

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

