# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class SessionInfo(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        SessionInfo - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'version': 'int',
            'session_id': 'str',
            'business_unit_id': 'str',
            'planning_groups_version': 'int',
            'date_of_session': 'datetime'
        }

        self.attribute_map = {
            'version': 'version',
            'session_id': 'sessionId',
            'business_unit_id': 'businessUnitId',
            'planning_groups_version': 'planningGroupsVersion',
            'date_of_session': 'dateOfSession'
        }

        self._version = None
        self._session_id = None
        self._business_unit_id = None
        self._planning_groups_version = None
        self._date_of_session = None

    @property
    def version(self) -> int:
        """
        Gets the version of this SessionInfo.
        Version of the continuous forecast session

        :return: The version of this SessionInfo.
        :rtype: int
        """
        return self._version

    @version.setter
    def version(self, version: int) -> None:
        """
        Sets the version of this SessionInfo.
        Version of the continuous forecast session

        :param version: The version of this SessionInfo.
        :type: int
        """
        

        self._version = version

    @property
    def session_id(self) -> str:
        """
        Gets the session_id of this SessionInfo.
        Session ID of the continuous forecast session

        :return: The session_id of this SessionInfo.
        :rtype: str
        """
        return self._session_id

    @session_id.setter
    def session_id(self, session_id: str) -> None:
        """
        Sets the session_id of this SessionInfo.
        Session ID of the continuous forecast session

        :param session_id: The session_id of this SessionInfo.
        :type: str
        """
        

        self._session_id = session_id

    @property
    def business_unit_id(self) -> str:
        """
        Gets the business_unit_id of this SessionInfo.
        Business unit ID of the continuous forecast session

        :return: The business_unit_id of this SessionInfo.
        :rtype: str
        """
        return self._business_unit_id

    @business_unit_id.setter
    def business_unit_id(self, business_unit_id: str) -> None:
        """
        Sets the business_unit_id of this SessionInfo.
        Business unit ID of the continuous forecast session

        :param business_unit_id: The business_unit_id of this SessionInfo.
        :type: str
        """
        

        self._business_unit_id = business_unit_id

    @property
    def planning_groups_version(self) -> int:
        """
        Gets the planning_groups_version of this SessionInfo.
        Version of the planning groups

        :return: The planning_groups_version of this SessionInfo.
        :rtype: int
        """
        return self._planning_groups_version

    @planning_groups_version.setter
    def planning_groups_version(self, planning_groups_version: int) -> None:
        """
        Sets the planning_groups_version of this SessionInfo.
        Version of the planning groups

        :param planning_groups_version: The planning_groups_version of this SessionInfo.
        :type: int
        """
        

        self._planning_groups_version = planning_groups_version

    @property
    def date_of_session(self) -> datetime:
        """
        Gets the date_of_session of this SessionInfo.
        Date and Time of the Session. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_of_session of this SessionInfo.
        :rtype: datetime
        """
        return self._date_of_session

    @date_of_session.setter
    def date_of_session(self, date_of_session: datetime) -> None:
        """
        Sets the date_of_session of this SessionInfo.
        Date and Time of the Session. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_of_session: The date_of_session of this SessionInfo.
        :type: datetime
        """
        

        self._date_of_session = date_of_session

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

