# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import AggregateHistoricalAvailability
    from . import SessionInfo
    from . import Snapshots

class SessionMetaDataResult(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        SessionMetaDataResult - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'session_info': 'SessionInfo',
            'snapshots': 'list[Snapshots]',
            'date_forecast_start': 'datetime',
            'date_historical_start': 'datetime',
            'aggregate_offered_historical_availability': 'AggregateHistoricalAvailability',
            'aggregate_average_handle_time_historical_availability': 'AggregateHistoricalAvailability'
        }

        self.attribute_map = {
            'session_info': 'sessionInfo',
            'snapshots': 'snapshots',
            'date_forecast_start': 'dateForecastStart',
            'date_historical_start': 'dateHistoricalStart',
            'aggregate_offered_historical_availability': 'aggregateOfferedHistoricalAvailability',
            'aggregate_average_handle_time_historical_availability': 'aggregateAverageHandleTimeHistoricalAvailability'
        }

        self._session_info = None
        self._snapshots = None
        self._date_forecast_start = None
        self._date_historical_start = None
        self._aggregate_offered_historical_availability = None
        self._aggregate_average_handle_time_historical_availability = None

    @property
    def session_info(self) -> 'SessionInfo':
        """
        Gets the session_info of this SessionMetaDataResult.
        Information about the continuous forecast session

        :return: The session_info of this SessionMetaDataResult.
        :rtype: SessionInfo
        """
        return self._session_info

    @session_info.setter
    def session_info(self, session_info: 'SessionInfo') -> None:
        """
        Sets the session_info of this SessionMetaDataResult.
        Information about the continuous forecast session

        :param session_info: The session_info of this SessionMetaDataResult.
        :type: SessionInfo
        """
        

        self._session_info = session_info

    @property
    def snapshots(self) -> List['Snapshots']:
        """
        Gets the snapshots of this SessionMetaDataResult.
        Captured snapshots

        :return: The snapshots of this SessionMetaDataResult.
        :rtype: list[Snapshots]
        """
        return self._snapshots

    @snapshots.setter
    def snapshots(self, snapshots: List['Snapshots']) -> None:
        """
        Sets the snapshots of this SessionMetaDataResult.
        Captured snapshots

        :param snapshots: The snapshots of this SessionMetaDataResult.
        :type: list[Snapshots]
        """
        

        self._snapshots = snapshots

    @property
    def date_forecast_start(self) -> datetime:
        """
        Gets the date_forecast_start of this SessionMetaDataResult.
        Start date of the forecast. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_forecast_start of this SessionMetaDataResult.
        :rtype: datetime
        """
        return self._date_forecast_start

    @date_forecast_start.setter
    def date_forecast_start(self, date_forecast_start: datetime) -> None:
        """
        Sets the date_forecast_start of this SessionMetaDataResult.
        Start date of the forecast. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_forecast_start: The date_forecast_start of this SessionMetaDataResult.
        :type: datetime
        """
        

        self._date_forecast_start = date_forecast_start

    @property
    def date_historical_start(self) -> datetime:
        """
        Gets the date_historical_start of this SessionMetaDataResult.
        Start date of the oldest available historical week. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_historical_start of this SessionMetaDataResult.
        :rtype: datetime
        """
        return self._date_historical_start

    @date_historical_start.setter
    def date_historical_start(self, date_historical_start: datetime) -> None:
        """
        Sets the date_historical_start of this SessionMetaDataResult.
        Start date of the oldest available historical week. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_historical_start: The date_historical_start of this SessionMetaDataResult.
        :type: datetime
        """
        

        self._date_historical_start = date_historical_start

    @property
    def aggregate_offered_historical_availability(self) -> 'AggregateHistoricalAvailability':
        """
        Gets the aggregate_offered_historical_availability of this SessionMetaDataResult.
        Total historical availability for offered metric across all planning groups

        :return: The aggregate_offered_historical_availability of this SessionMetaDataResult.
        :rtype: AggregateHistoricalAvailability
        """
        return self._aggregate_offered_historical_availability

    @aggregate_offered_historical_availability.setter
    def aggregate_offered_historical_availability(self, aggregate_offered_historical_availability: 'AggregateHistoricalAvailability') -> None:
        """
        Sets the aggregate_offered_historical_availability of this SessionMetaDataResult.
        Total historical availability for offered metric across all planning groups

        :param aggregate_offered_historical_availability: The aggregate_offered_historical_availability of this SessionMetaDataResult.
        :type: AggregateHistoricalAvailability
        """
        

        self._aggregate_offered_historical_availability = aggregate_offered_historical_availability

    @property
    def aggregate_average_handle_time_historical_availability(self) -> 'AggregateHistoricalAvailability':
        """
        Gets the aggregate_average_handle_time_historical_availability of this SessionMetaDataResult.
        Total historical availability for average handle time metric across all planning groups

        :return: The aggregate_average_handle_time_historical_availability of this SessionMetaDataResult.
        :rtype: AggregateHistoricalAvailability
        """
        return self._aggregate_average_handle_time_historical_availability

    @aggregate_average_handle_time_historical_availability.setter
    def aggregate_average_handle_time_historical_availability(self, aggregate_average_handle_time_historical_availability: 'AggregateHistoricalAvailability') -> None:
        """
        Sets the aggregate_average_handle_time_historical_availability of this SessionMetaDataResult.
        Total historical availability for average handle time metric across all planning groups

        :param aggregate_average_handle_time_historical_availability: The aggregate_average_handle_time_historical_availability of this SessionMetaDataResult.
        :type: AggregateHistoricalAvailability
        """
        

        self._aggregate_average_handle_time_historical_availability = aggregate_average_handle_time_historical_availability

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

