# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class ShiftTradeExternalActivityRule(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        ShiftTradeExternalActivityRule - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'external_activity_type': 'str',
            'action': 'str',
            'activity_code_id_replacement': 'str'
        }

        self.attribute_map = {
            'external_activity_type': 'externalActivityType',
            'action': 'action',
            'activity_code_id_replacement': 'activityCodeIdReplacement'
        }

        self._external_activity_type = None
        self._action = None
        self._activity_code_id_replacement = None

    @property
    def external_activity_type(self) -> str:
        """
        Gets the external_activity_type of this ShiftTradeExternalActivityRule.
        The external activity type to which to apply this rule

        :return: The external_activity_type of this ShiftTradeExternalActivityRule.
        :rtype: str
        """
        return self._external_activity_type

    @external_activity_type.setter
    def external_activity_type(self, external_activity_type: str) -> None:
        """
        Sets the external_activity_type of this ShiftTradeExternalActivityRule.
        The external activity type to which to apply this rule

        :param external_activity_type: The external_activity_type of this ShiftTradeExternalActivityRule.
        :type: str
        """
        if isinstance(external_activity_type, int):
            external_activity_type = str(external_activity_type)
        allowed_values = ["ActivityPlan", "Coaching", "Learning"]
        if external_activity_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for external_activity_type -> " + external_activity_type)
            self._external_activity_type = "outdated_sdk_version"
        else:
            self._external_activity_type = external_activity_type

    @property
    def action(self) -> str:
        """
        Gets the action of this ShiftTradeExternalActivityRule.
        The action this rule invokes

        :return: The action of this ShiftTradeExternalActivityRule.
        :rtype: str
        """
        return self._action

    @action.setter
    def action(self, action: str) -> None:
        """
        Sets the action of this ShiftTradeExternalActivityRule.
        The action this rule invokes

        :param action: The action of this ShiftTradeExternalActivityRule.
        :type: str
        """
        if isinstance(action, int):
            action = str(action)
        allowed_values = ["DoNotAllowTrade", "KeepWithAgent"]
        if action.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for action -> " + action)
            self._action = "outdated_sdk_version"
        else:
            self._action = action

    @property
    def activity_code_id_replacement(self) -> str:
        """
        Gets the activity_code_id_replacement of this ShiftTradeExternalActivityRule.
        The ID of the activity code with which to replace to replace external activities (required if action == KeepWithAgent, must be a default activity code ID)

        :return: The activity_code_id_replacement of this ShiftTradeExternalActivityRule.
        :rtype: str
        """
        return self._activity_code_id_replacement

    @activity_code_id_replacement.setter
    def activity_code_id_replacement(self, activity_code_id_replacement: str) -> None:
        """
        Sets the activity_code_id_replacement of this ShiftTradeExternalActivityRule.
        The ID of the activity code with which to replace to replace external activities (required if action == KeepWithAgent, must be a default activity code ID)

        :param activity_code_id_replacement: The activity_code_id_replacement of this ShiftTradeExternalActivityRule.
        :type: str
        """
        

        self._activity_code_id_replacement = activity_code_id_replacement

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

