# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class SkillCombinationInfo(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        SkillCombinationInfo - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'skill_combination': 'list[str]',
            'total_count': 'int',
            'remaining_count': 'int'
        }

        self.attribute_map = {
            'skill_combination': 'skillCombination',
            'total_count': 'totalCount',
            'remaining_count': 'remainingCount'
        }

        self._skill_combination = None
        self._total_count = None
        self._remaining_count = None

    @property
    def skill_combination(self) -> List[str]:
        """
        Gets the skill_combination of this SkillCombinationInfo.
        A skill combination in the contact queue

        :return: The skill_combination of this SkillCombinationInfo.
        :rtype: list[str]
        """
        return self._skill_combination

    @skill_combination.setter
    def skill_combination(self, skill_combination: List[str]) -> None:
        """
        Sets the skill_combination of this SkillCombinationInfo.
        A skill combination in the contact queue

        :param skill_combination: The skill_combination of this SkillCombinationInfo.
        :type: list[str]
        """
        

        self._skill_combination = skill_combination

    @property
    def total_count(self) -> int:
        """
        Gets the total_count of this SkillCombinationInfo.
        Number of total contacts in the contact queue for this skill combination

        :return: The total_count of this SkillCombinationInfo.
        :rtype: int
        """
        return self._total_count

    @total_count.setter
    def total_count(self, total_count: int) -> None:
        """
        Sets the total_count of this SkillCombinationInfo.
        Number of total contacts in the contact queue for this skill combination

        :param total_count: The total_count of this SkillCombinationInfo.
        :type: int
        """
        

        self._total_count = total_count

    @property
    def remaining_count(self) -> int:
        """
        Gets the remaining_count of this SkillCombinationInfo.
        Number of remaining contacts in the contact queue for this skill combination

        :return: The remaining_count of this SkillCombinationInfo.
        :rtype: int
        """
        return self._remaining_count

    @remaining_count.setter
    def remaining_count(self, remaining_count: int) -> None:
        """
        Sets the remaining_count of this SkillCombinationInfo.
        Number of remaining contacts in the contact queue for this skill combination

        :param remaining_count: The remaining_count of this SkillCombinationInfo.
        :type: int
        """
        

        self._remaining_count = remaining_count

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

