# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import Compliance
    from . import SupportedContentReference

class SmsPhoneNumberImport(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        SmsPhoneNumberImport - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'phone_number': 'str',
            'phone_number_type': 'str',
            'country_code': 'str',
            'integration_id': 'str',
            'compliance': 'Compliance',
            'supported_content': 'SupportedContentReference',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'phone_number': 'phoneNumber',
            'phone_number_type': 'phoneNumberType',
            'country_code': 'countryCode',
            'integration_id': 'integrationId',
            'compliance': 'compliance',
            'supported_content': 'supportedContent',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._phone_number = None
        self._phone_number_type = None
        self._country_code = None
        self._integration_id = None
        self._compliance = None
        self._supported_content = None
        self._self_uri = None

    @property
    def id(self) -> str:
        """
        Gets the id of this SmsPhoneNumberImport.
        The globally unique identifier for the object.

        :return: The id of this SmsPhoneNumberImport.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this SmsPhoneNumberImport.
        The globally unique identifier for the object.

        :param id: The id of this SmsPhoneNumberImport.
        :type: str
        """
        

        self._id = id

    @property
    def phone_number(self) -> str:
        """
        Gets the phone_number of this SmsPhoneNumberImport.
        A phone number to be used for SMS communications. E.g. +13175555555 or +34234234234

        :return: The phone_number of this SmsPhoneNumberImport.
        :rtype: str
        """
        return self._phone_number

    @phone_number.setter
    def phone_number(self, phone_number: str) -> None:
        """
        Sets the phone_number of this SmsPhoneNumberImport.
        A phone number to be used for SMS communications. E.g. +13175555555 or +34234234234

        :param phone_number: The phone_number of this SmsPhoneNumberImport.
        :type: str
        """
        

        self._phone_number = phone_number

    @property
    def phone_number_type(self) -> str:
        """
        Gets the phone_number_type of this SmsPhoneNumberImport.
        Type of the phone number provisioned.

        :return: The phone_number_type of this SmsPhoneNumberImport.
        :rtype: str
        """
        return self._phone_number_type

    @phone_number_type.setter
    def phone_number_type(self, phone_number_type: str) -> None:
        """
        Sets the phone_number_type of this SmsPhoneNumberImport.
        Type of the phone number provisioned.

        :param phone_number_type: The phone_number_type of this SmsPhoneNumberImport.
        :type: str
        """
        if isinstance(phone_number_type, int):
            phone_number_type = str(phone_number_type)
        allowed_values = ["local", "mobile", "tollfree", "shortcode"]
        if phone_number_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for phone_number_type -> " + phone_number_type)
            self._phone_number_type = "outdated_sdk_version"
        else:
            self._phone_number_type = phone_number_type

    @property
    def country_code(self) -> str:
        """
        Gets the country_code of this SmsPhoneNumberImport.
        The ISO 3166-1 alpha-2 country code of the country this phone number is associated with.

        :return: The country_code of this SmsPhoneNumberImport.
        :rtype: str
        """
        return self._country_code

    @country_code.setter
    def country_code(self, country_code: str) -> None:
        """
        Sets the country_code of this SmsPhoneNumberImport.
        The ISO 3166-1 alpha-2 country code of the country this phone number is associated with.

        :param country_code: The country_code of this SmsPhoneNumberImport.
        :type: str
        """
        

        self._country_code = country_code

    @property
    def integration_id(self) -> str:
        """
        Gets the integration_id of this SmsPhoneNumberImport.
        The id of the Genesys Cloud integration this phone number belongs to.

        :return: The integration_id of this SmsPhoneNumberImport.
        :rtype: str
        """
        return self._integration_id

    @integration_id.setter
    def integration_id(self, integration_id: str) -> None:
        """
        Sets the integration_id of this SmsPhoneNumberImport.
        The id of the Genesys Cloud integration this phone number belongs to.

        :param integration_id: The integration_id of this SmsPhoneNumberImport.
        :type: str
        """
        

        self._integration_id = integration_id

    @property
    def compliance(self) -> 'Compliance':
        """
        Gets the compliance of this SmsPhoneNumberImport.
        Compliance configuration for short codes, including help, stop and opt in.

        :return: The compliance of this SmsPhoneNumberImport.
        :rtype: Compliance
        """
        return self._compliance

    @compliance.setter
    def compliance(self, compliance: 'Compliance') -> None:
        """
        Sets the compliance of this SmsPhoneNumberImport.
        Compliance configuration for short codes, including help, stop and opt in.

        :param compliance: The compliance of this SmsPhoneNumberImport.
        :type: Compliance
        """
        

        self._compliance = compliance

    @property
    def supported_content(self) -> 'SupportedContentReference':
        """
        Gets the supported_content of this SmsPhoneNumberImport.
        Defines the media SupportedContent profile configured for an MMS capable phone number.

        :return: The supported_content of this SmsPhoneNumberImport.
        :rtype: SupportedContentReference
        """
        return self._supported_content

    @supported_content.setter
    def supported_content(self, supported_content: 'SupportedContentReference') -> None:
        """
        Sets the supported_content of this SmsPhoneNumberImport.
        Defines the media SupportedContent profile configured for an MMS capable phone number.

        :param supported_content: The supported_content of this SmsPhoneNumberImport.
        :type: SupportedContentReference
        """
        

        self._supported_content = supported_content

    @property
    def self_uri(self) -> str:
        """
        Gets the self_uri of this SmsPhoneNumberImport.
        The URI for this object

        :return: The self_uri of this SmsPhoneNumberImport.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri: str) -> None:
        """
        Sets the self_uri of this SmsPhoneNumberImport.
        The URI for this object

        :param self_uri: The self_uri of this SmsPhoneNumberImport.
        :type: str
        """
        

        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

