# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import SnapshotMetaData
    from . import SnapshotMetricData

class SnapshotFiles(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        SnapshotFiles - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'meta_data': 'SnapshotMetaData',
            'offered': 'SnapshotMetricData',
            'average_handle_time': 'SnapshotMetricData'
        }

        self.attribute_map = {
            'meta_data': 'metaData',
            'offered': 'offered',
            'average_handle_time': 'averageHandleTime'
        }

        self._meta_data = None
        self._offered = None
        self._average_handle_time = None

    @property
    def meta_data(self) -> 'SnapshotMetaData':
        """
        Gets the meta_data of this SnapshotFiles.
        Metadata for requested snapshot

        :return: The meta_data of this SnapshotFiles.
        :rtype: SnapshotMetaData
        """
        return self._meta_data

    @meta_data.setter
    def meta_data(self, meta_data: 'SnapshotMetaData') -> None:
        """
        Sets the meta_data of this SnapshotFiles.
        Metadata for requested snapshot

        :param meta_data: The meta_data of this SnapshotFiles.
        :type: SnapshotMetaData
        """
        

        self._meta_data = meta_data

    @property
    def offered(self) -> 'SnapshotMetricData':
        """
        Gets the offered of this SnapshotFiles.
        Offered data for the requested snapshot

        :return: The offered of this SnapshotFiles.
        :rtype: SnapshotMetricData
        """
        return self._offered

    @offered.setter
    def offered(self, offered: 'SnapshotMetricData') -> None:
        """
        Sets the offered of this SnapshotFiles.
        Offered data for the requested snapshot

        :param offered: The offered of this SnapshotFiles.
        :type: SnapshotMetricData
        """
        

        self._offered = offered

    @property
    def average_handle_time(self) -> 'SnapshotMetricData':
        """
        Gets the average_handle_time of this SnapshotFiles.
        Average handle time data for the requested snapshot

        :return: The average_handle_time of this SnapshotFiles.
        :rtype: SnapshotMetricData
        """
        return self._average_handle_time

    @average_handle_time.setter
    def average_handle_time(self, average_handle_time: 'SnapshotMetricData') -> None:
        """
        Sets the average_handle_time of this SnapshotFiles.
        Average handle time data for the requested snapshot

        :param average_handle_time: The average_handle_time of this SnapshotFiles.
        :type: SnapshotMetricData
        """
        

        self._average_handle_time = average_handle_time

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

