# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import SocialMediaQueryFilter

class SocialMediaAsyncDetailQuery(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        SocialMediaAsyncDetailQuery - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'interval': 'str',
            'time_zone': 'str',
            'filter': 'SocialMediaQueryFilter',
            'topic_ids': 'list[str]',
            'page_size': 'int',
            'order': 'str'
        }

        self.attribute_map = {
            'interval': 'interval',
            'time_zone': 'timeZone',
            'filter': 'filter',
            'topic_ids': 'topicIds',
            'page_size': 'pageSize',
            'order': 'order'
        }

        self._interval = None
        self._time_zone = None
        self._filter = None
        self._topic_ids = None
        self._page_size = None
        self._order = None

    @property
    def interval(self) -> str:
        """
        Gets the interval of this SocialMediaAsyncDetailQuery.
        Behaves like one clause in a SQL WHERE. Specifies the date and time range of data being queried. Intervals are represented as an ISO-8601 string. For example: YYYY-MM-DDThh:mm:ss/YYYY-MM-DDThh:mm:ss

        :return: The interval of this SocialMediaAsyncDetailQuery.
        :rtype: str
        """
        return self._interval

    @interval.setter
    def interval(self, interval: str) -> None:
        """
        Sets the interval of this SocialMediaAsyncDetailQuery.
        Behaves like one clause in a SQL WHERE. Specifies the date and time range of data being queried. Intervals are represented as an ISO-8601 string. For example: YYYY-MM-DDThh:mm:ss/YYYY-MM-DDThh:mm:ss

        :param interval: The interval of this SocialMediaAsyncDetailQuery.
        :type: str
        """
        

        self._interval = interval

    @property
    def time_zone(self) -> str:
        """
        Gets the time_zone of this SocialMediaAsyncDetailQuery.
        Time zone context used to calculate response intervals (this allows resolving DST changes). The interval offset is used even when timeZone is specified. Default is UTC. Time zones are represented as a string of the zone name as found in the IANA time zone database. For example: UTC, Etc/UTC, or Europe/London

        :return: The time_zone of this SocialMediaAsyncDetailQuery.
        :rtype: str
        """
        return self._time_zone

    @time_zone.setter
    def time_zone(self, time_zone: str) -> None:
        """
        Sets the time_zone of this SocialMediaAsyncDetailQuery.
        Time zone context used to calculate response intervals (this allows resolving DST changes). The interval offset is used even when timeZone is specified. Default is UTC. Time zones are represented as a string of the zone name as found in the IANA time zone database. For example: UTC, Etc/UTC, or Europe/London

        :param time_zone: The time_zone of this SocialMediaAsyncDetailQuery.
        :type: str
        """
        

        self._time_zone = time_zone

    @property
    def filter(self) -> 'SocialMediaQueryFilter':
        """
        Gets the filter of this SocialMediaAsyncDetailQuery.
        Behaves like a SQL WHERE clause. This is ANDed with the interval parameter. Expresses boolean logical predicates as well as dimensional filters

        :return: The filter of this SocialMediaAsyncDetailQuery.
        :rtype: SocialMediaQueryFilter
        """
        return self._filter

    @filter.setter
    def filter(self, filter: 'SocialMediaQueryFilter') -> None:
        """
        Sets the filter of this SocialMediaAsyncDetailQuery.
        Behaves like a SQL WHERE clause. This is ANDed with the interval parameter. Expresses boolean logical predicates as well as dimensional filters

        :param filter: The filter of this SocialMediaAsyncDetailQuery.
        :type: SocialMediaQueryFilter
        """
        

        self._filter = filter

    @property
    def topic_ids(self) -> List[str]:
        """
        Gets the topic_ids of this SocialMediaAsyncDetailQuery.
        List of topicIds to query in

        :return: The topic_ids of this SocialMediaAsyncDetailQuery.
        :rtype: list[str]
        """
        return self._topic_ids

    @topic_ids.setter
    def topic_ids(self, topic_ids: List[str]) -> None:
        """
        Sets the topic_ids of this SocialMediaAsyncDetailQuery.
        List of topicIds to query in

        :param topic_ids: The topic_ids of this SocialMediaAsyncDetailQuery.
        :type: list[str]
        """
        

        self._topic_ids = topic_ids

    @property
    def page_size(self) -> int:
        """
        Gets the page_size of this SocialMediaAsyncDetailQuery.
        The number of results per page

        :return: The page_size of this SocialMediaAsyncDetailQuery.
        :rtype: int
        """
        return self._page_size

    @page_size.setter
    def page_size(self, page_size: int) -> None:
        """
        Sets the page_size of this SocialMediaAsyncDetailQuery.
        The number of results per page

        :param page_size: The page_size of this SocialMediaAsyncDetailQuery.
        :type: int
        """
        

        self._page_size = page_size

    @property
    def order(self) -> str:
        """
        Gets the order of this SocialMediaAsyncDetailQuery.
        Sorting of results based on time

        :return: The order of this SocialMediaAsyncDetailQuery.
        :rtype: str
        """
        return self._order

    @order.setter
    def order(self, order: str) -> None:
        """
        Sets the order of this SocialMediaAsyncDetailQuery.
        Sorting of results based on time

        :param order: The order of this SocialMediaAsyncDetailQuery.
        :type: str
        """
        if isinstance(order, int):
            order = str(order)
        allowed_values = ["asc", "desc"]
        if order.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for order -> " + order)
            self._order = "outdated_sdk_version"
        else:
            self._order = order

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

