# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class SourceConfiguration(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        SourceConfiguration - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'source_id': 'str',
            'interaction_id': 'str',
            'tag_id': 'str'
        }

        self.attribute_map = {
            'source_id': 'sourceId',
            'interaction_id': 'interactionId',
            'tag_id': 'tagId'
        }

        self._source_id = None
        self._interaction_id = None
        self._tag_id = None

    @property
    def source_id(self) -> str:
        """
        Gets the source_id of this SourceConfiguration.
        Identifies the external platform that is the source of the conversation.

        :return: The source_id of this SourceConfiguration.
        :rtype: str
        """
        return self._source_id

    @source_id.setter
    def source_id(self, source_id: str) -> None:
        """
        Sets the source_id of this SourceConfiguration.
        Identifies the external platform that is the source of the conversation.

        :param source_id: The source_id of this SourceConfiguration.
        :type: str
        """
        

        self._source_id = source_id

    @property
    def interaction_id(self) -> str:
        """
        Gets the interaction_id of this SourceConfiguration.
        The customer's unique external identifier associated with the conversation that comes from the external platform.

        :return: The interaction_id of this SourceConfiguration.
        :rtype: str
        """
        return self._interaction_id

    @interaction_id.setter
    def interaction_id(self, interaction_id: str) -> None:
        """
        Sets the interaction_id of this SourceConfiguration.
        The customer's unique external identifier associated with the conversation that comes from the external platform.

        :param interaction_id: The interaction_id of this SourceConfiguration.
        :type: str
        """
        

        self._interaction_id = interaction_id

    @property
    def tag_id(self) -> str:
        """
        Gets the tag_id of this SourceConfiguration.
        The customer's external identifier or tag associated with the conversation. If set, it will be used to tag the conversation.

        :return: The tag_id of this SourceConfiguration.
        :rtype: str
        """
        return self._tag_id

    @tag_id.setter
    def tag_id(self, tag_id: str) -> None:
        """
        Sets the tag_id of this SourceConfiguration.
        The customer's external identifier or tag associated with the conversation. If set, it will be used to tag the conversation.

        :param tag_id: The tag_id of this SourceConfiguration.
        :type: str
        """
        

        self._tag_id = tag_id

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

