# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import ErrorBody

class SourceLastSync(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        SourceLastSync - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'state': 'str',
            'date_started': 'datetime',
            'date_ended': 'datetime',
            'error': 'ErrorBody'
        }

        self.attribute_map = {
            'state': 'state',
            'date_started': 'dateStarted',
            'date_ended': 'dateEnded',
            'error': 'error'
        }

        self._state = None
        self._date_started = None
        self._date_ended = None
        self._error = None

    @property
    def state(self) -> str:
        """
        Gets the state of this SourceLastSync.
        State of the last synchronization.

        :return: The state of this SourceLastSync.
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state: str) -> None:
        """
        Sets the state of this SourceLastSync.
        State of the last synchronization.

        :param state: The state of this SourceLastSync.
        :type: str
        """
        if isinstance(state, int):
            state = str(state)
        allowed_values = ["Success", "Failed", "InProgress", "Unknown"]
        if state.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for state -> " + state)
            self._state = "outdated_sdk_version"
        else:
            self._state = state

    @property
    def date_started(self) -> datetime:
        """
        Gets the date_started of this SourceLastSync.
        Last synchronization start-time. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_started of this SourceLastSync.
        :rtype: datetime
        """
        return self._date_started

    @date_started.setter
    def date_started(self, date_started: datetime) -> None:
        """
        Sets the date_started of this SourceLastSync.
        Last synchronization start-time. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_started: The date_started of this SourceLastSync.
        :type: datetime
        """
        

        self._date_started = date_started

    @property
    def date_ended(self) -> datetime:
        """
        Gets the date_ended of this SourceLastSync.
        Last synchronization end-time. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_ended of this SourceLastSync.
        :rtype: datetime
        """
        return self._date_ended

    @date_ended.setter
    def date_ended(self, date_ended: datetime) -> None:
        """
        Sets the date_ended of this SourceLastSync.
        Last synchronization end-time. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_ended: The date_ended of this SourceLastSync.
        :type: datetime
        """
        

        self._date_ended = date_ended

    @property
    def error(self) -> 'ErrorBody':
        """
        Gets the error of this SourceLastSync.
        Optional error message of the last synchronization.

        :return: The error of this SourceLastSync.
        :rtype: ErrorBody
        """
        return self._error

    @error.setter
    def error(self, error: 'ErrorBody') -> None:
        """
        Sets the error of this SourceLastSync.
        Optional error message of the last synchronization.

        :param error: The error of this SourceLastSync.
        :type: ErrorBody
        """
        

        self._error = error

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

