# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import AddressableEntityRef
    from . import Operand

class StaCategory(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        StaCategory - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'description': 'str',
            'interaction_type': 'str',
            'criteria': 'Operand',
            'created_by': 'AddressableEntityRef',
            'date_created': 'datetime',
            'modified_by': 'AddressableEntityRef',
            'date_modified': 'datetime',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'description': 'description',
            'interaction_type': 'interactionType',
            'criteria': 'criteria',
            'created_by': 'createdBy',
            'date_created': 'dateCreated',
            'modified_by': 'modifiedBy',
            'date_modified': 'dateModified',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._description = None
        self._interaction_type = None
        self._criteria = None
        self._created_by = None
        self._date_created = None
        self._modified_by = None
        self._date_modified = None
        self._self_uri = None

    @property
    def id(self) -> str:
        """
        Gets the id of this StaCategory.
        The globally unique identifier for the object.

        :return: The id of this StaCategory.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this StaCategory.
        The globally unique identifier for the object.

        :param id: The id of this StaCategory.
        :type: str
        """
        

        self._id = id

    @property
    def name(self) -> str:
        """
        Gets the name of this StaCategory.


        :return: The name of this StaCategory.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str) -> None:
        """
        Sets the name of this StaCategory.


        :param name: The name of this StaCategory.
        :type: str
        """
        

        self._name = name

    @property
    def description(self) -> str:
        """
        Gets the description of this StaCategory.
        The description of the category

        :return: The description of this StaCategory.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description: str) -> None:
        """
        Sets the description of this StaCategory.
        The description of the category

        :param description: The description of this StaCategory.
        :type: str
        """
        

        self._description = description

    @property
    def interaction_type(self) -> str:
        """
        Gets the interaction_type of this StaCategory.
        The type of interaction the category will apply to

        :return: The interaction_type of this StaCategory.
        :rtype: str
        """
        return self._interaction_type

    @interaction_type.setter
    def interaction_type(self, interaction_type: str) -> None:
        """
        Sets the interaction_type of this StaCategory.
        The type of interaction the category will apply to

        :param interaction_type: The interaction_type of this StaCategory.
        :type: str
        """
        if isinstance(interaction_type, int):
            interaction_type = str(interaction_type)
        allowed_values = ["Voice", "Digital", "All"]
        if interaction_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for interaction_type -> " + interaction_type)
            self._interaction_type = "outdated_sdk_version"
        else:
            self._interaction_type = interaction_type

    @property
    def criteria(self) -> 'Operand':
        """
        Gets the criteria of this StaCategory.
        A collection of conditions joined together by logical operation to provide more refined filtering of conversations

        :return: The criteria of this StaCategory.
        :rtype: Operand
        """
        return self._criteria

    @criteria.setter
    def criteria(self, criteria: 'Operand') -> None:
        """
        Sets the criteria of this StaCategory.
        A collection of conditions joined together by logical operation to provide more refined filtering of conversations

        :param criteria: The criteria of this StaCategory.
        :type: Operand
        """
        

        self._criteria = criteria

    @property
    def created_by(self) -> 'AddressableEntityRef':
        """
        Gets the created_by of this StaCategory.
        The user who created the record

        :return: The created_by of this StaCategory.
        :rtype: AddressableEntityRef
        """
        return self._created_by

    @created_by.setter
    def created_by(self, created_by: 'AddressableEntityRef') -> None:
        """
        Sets the created_by of this StaCategory.
        The user who created the record

        :param created_by: The created_by of this StaCategory.
        :type: AddressableEntityRef
        """
        

        self._created_by = created_by

    @property
    def date_created(self) -> datetime:
        """
        Gets the date_created of this StaCategory.
        The creation date of the record. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_created of this StaCategory.
        :rtype: datetime
        """
        return self._date_created

    @date_created.setter
    def date_created(self, date_created: datetime) -> None:
        """
        Sets the date_created of this StaCategory.
        The creation date of the record. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_created: The date_created of this StaCategory.
        :type: datetime
        """
        

        self._date_created = date_created

    @property
    def modified_by(self) -> 'AddressableEntityRef':
        """
        Gets the modified_by of this StaCategory.
        The user who last modified the record

        :return: The modified_by of this StaCategory.
        :rtype: AddressableEntityRef
        """
        return self._modified_by

    @modified_by.setter
    def modified_by(self, modified_by: 'AddressableEntityRef') -> None:
        """
        Sets the modified_by of this StaCategory.
        The user who last modified the record

        :param modified_by: The modified_by of this StaCategory.
        :type: AddressableEntityRef
        """
        

        self._modified_by = modified_by

    @property
    def date_modified(self) -> datetime:
        """
        Gets the date_modified of this StaCategory.
        The last modified date of the record. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_modified of this StaCategory.
        :rtype: datetime
        """
        return self._date_modified

    @date_modified.setter
    def date_modified(self, date_modified: datetime) -> None:
        """
        Sets the date_modified of this StaCategory.
        The last modified date of the record. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_modified: The date_modified of this StaCategory.
        :type: datetime
        """
        

        self._date_modified = date_modified

    @property
    def self_uri(self) -> str:
        """
        Gets the self_uri of this StaCategory.
        The URI for this object

        :return: The self_uri of this StaCategory.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri: str) -> None:
        """
        Sets the self_uri of this StaCategory.
        The URI for this object

        :param self_uri: The self_uri of this StaCategory.
        :type: str
        """
        

        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

