# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class StaffingGroupAllocation(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        StaffingGroupAllocation - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'staffing_group_id': 'str',
            'shrinkage_percentages': 'list[float]',
            'attrition_percentages': 'list[float]',
            'new_hires_full_time_equivalent_count': 'list[float]',
            'starting_weekly_full_time_equivalent_count': 'float',
            'planning_group_ids': 'list[str]'
        }

        self.attribute_map = {
            'staffing_group_id': 'staffingGroupId',
            'shrinkage_percentages': 'shrinkagePercentages',
            'attrition_percentages': 'attritionPercentages',
            'new_hires_full_time_equivalent_count': 'newHiresFullTimeEquivalentCount',
            'starting_weekly_full_time_equivalent_count': 'startingWeeklyFullTimeEquivalentCount',
            'planning_group_ids': 'planningGroupIds'
        }

        self._staffing_group_id = None
        self._shrinkage_percentages = None
        self._attrition_percentages = None
        self._new_hires_full_time_equivalent_count = None
        self._starting_weekly_full_time_equivalent_count = None
        self._planning_group_ids = None

    @property
    def staffing_group_id(self) -> str:
        """
        Gets the staffing_group_id of this StaffingGroupAllocation.
        The staffing group to which the result allocation belongs

        :return: The staffing_group_id of this StaffingGroupAllocation.
        :rtype: str
        """
        return self._staffing_group_id

    @staffing_group_id.setter
    def staffing_group_id(self, staffing_group_id: str) -> None:
        """
        Sets the staffing_group_id of this StaffingGroupAllocation.
        The staffing group to which the result allocation belongs

        :param staffing_group_id: The staffing_group_id of this StaffingGroupAllocation.
        :type: str
        """
        

        self._staffing_group_id = staffing_group_id

    @property
    def shrinkage_percentages(self) -> List[float]:
        """
        Gets the shrinkage_percentages of this StaffingGroupAllocation.
        The weekly projected shrinkage percentage of staffing group, in the scale of 0 - 100

        :return: The shrinkage_percentages of this StaffingGroupAllocation.
        :rtype: list[float]
        """
        return self._shrinkage_percentages

    @shrinkage_percentages.setter
    def shrinkage_percentages(self, shrinkage_percentages: List[float]) -> None:
        """
        Sets the shrinkage_percentages of this StaffingGroupAllocation.
        The weekly projected shrinkage percentage of staffing group, in the scale of 0 - 100

        :param shrinkage_percentages: The shrinkage_percentages of this StaffingGroupAllocation.
        :type: list[float]
        """
        

        self._shrinkage_percentages = shrinkage_percentages

    @property
    def attrition_percentages(self) -> List[float]:
        """
        Gets the attrition_percentages of this StaffingGroupAllocation.
        The weekly projected attrition percentage of the staffing group, in the scale of 0 - 100

        :return: The attrition_percentages of this StaffingGroupAllocation.
        :rtype: list[float]
        """
        return self._attrition_percentages

    @attrition_percentages.setter
    def attrition_percentages(self, attrition_percentages: List[float]) -> None:
        """
        Sets the attrition_percentages of this StaffingGroupAllocation.
        The weekly projected attrition percentage of the staffing group, in the scale of 0 - 100

        :param attrition_percentages: The attrition_percentages of this StaffingGroupAllocation.
        :type: list[float]
        """
        

        self._attrition_percentages = attrition_percentages

    @property
    def new_hires_full_time_equivalent_count(self) -> List[float]:
        """
        Gets the new_hires_full_time_equivalent_count of this StaffingGroupAllocation.
        The weekly projected full time equivalent agents of new hire agents added to the staffing group

        :return: The new_hires_full_time_equivalent_count of this StaffingGroupAllocation.
        :rtype: list[float]
        """
        return self._new_hires_full_time_equivalent_count

    @new_hires_full_time_equivalent_count.setter
    def new_hires_full_time_equivalent_count(self, new_hires_full_time_equivalent_count: List[float]) -> None:
        """
        Sets the new_hires_full_time_equivalent_count of this StaffingGroupAllocation.
        The weekly projected full time equivalent agents of new hire agents added to the staffing group

        :param new_hires_full_time_equivalent_count: The new_hires_full_time_equivalent_count of this StaffingGroupAllocation.
        :type: list[float]
        """
        

        self._new_hires_full_time_equivalent_count = new_hires_full_time_equivalent_count

    @property
    def starting_weekly_full_time_equivalent_count(self) -> float:
        """
        Gets the starting_weekly_full_time_equivalent_count of this StaffingGroupAllocation.
        The weekly count of full time equivalent agents that can be used for the first week of the capacity plan

        :return: The starting_weekly_full_time_equivalent_count of this StaffingGroupAllocation.
        :rtype: float
        """
        return self._starting_weekly_full_time_equivalent_count

    @starting_weekly_full_time_equivalent_count.setter
    def starting_weekly_full_time_equivalent_count(self, starting_weekly_full_time_equivalent_count: float) -> None:
        """
        Sets the starting_weekly_full_time_equivalent_count of this StaffingGroupAllocation.
        The weekly count of full time equivalent agents that can be used for the first week of the capacity plan

        :param starting_weekly_full_time_equivalent_count: The starting_weekly_full_time_equivalent_count of this StaffingGroupAllocation.
        :type: float
        """
        

        self._starting_weekly_full_time_equivalent_count = starting_weekly_full_time_equivalent_count

    @property
    def planning_group_ids(self) -> List[str]:
        """
        Gets the planning_group_ids of this StaffingGroupAllocation.
        The IDs of the planning groups associated with this staffing group

        :return: The planning_group_ids of this StaffingGroupAllocation.
        :rtype: list[str]
        """
        return self._planning_group_ids

    @planning_group_ids.setter
    def planning_group_ids(self, planning_group_ids: List[str]) -> None:
        """
        Sets the planning_group_ids of this StaffingGroupAllocation.
        The IDs of the planning groups associated with this staffing group

        :param planning_group_ids: The planning_group_ids of this StaffingGroupAllocation.
        :type: list[str]
        """
        

        self._planning_group_ids = planning_group_ids

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

