# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import StaffingGroupReference
    from . import UserReference

class StaffingGroupMetricChangeResponse(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        StaffingGroupMetricChangeResponse - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'number_of_weeks': 'int',
            'week_start_number': 'int',
            'value': 'float',
            'metric': 'str',
            'notes': 'str',
            'staffing_groups': 'list[StaffingGroupReference]',
            'created_by': 'UserReference',
            'created_date': 'datetime'
        }

        self.attribute_map = {
            'number_of_weeks': 'numberOfWeeks',
            'week_start_number': 'weekStartNumber',
            'value': 'value',
            'metric': 'metric',
            'notes': 'notes',
            'staffing_groups': 'staffingGroups',
            'created_by': 'createdBy',
            'created_date': 'createdDate'
        }

        self._number_of_weeks = None
        self._week_start_number = None
        self._value = None
        self._metric = None
        self._notes = None
        self._staffing_groups = None
        self._created_by = None
        self._created_date = None

    @property
    def number_of_weeks(self) -> int:
        """
        Gets the number_of_weeks of this StaffingGroupMetricChangeResponse.
        The number of weeks to which the metric change applies

        :return: The number_of_weeks of this StaffingGroupMetricChangeResponse.
        :rtype: int
        """
        return self._number_of_weeks

    @number_of_weeks.setter
    def number_of_weeks(self, number_of_weeks: int) -> None:
        """
        Sets the number_of_weeks of this StaffingGroupMetricChangeResponse.
        The number of weeks to which the metric change applies

        :param number_of_weeks: The number_of_weeks of this StaffingGroupMetricChangeResponse.
        :type: int
        """
        

        self._number_of_weeks = number_of_weeks

    @property
    def week_start_number(self) -> int:
        """
        Gets the week_start_number of this StaffingGroupMetricChangeResponse.
        The start number of the week (starting from 1) to which the metric change applies, related to numberOfWeeks

        :return: The week_start_number of this StaffingGroupMetricChangeResponse.
        :rtype: int
        """
        return self._week_start_number

    @week_start_number.setter
    def week_start_number(self, week_start_number: int) -> None:
        """
        Sets the week_start_number of this StaffingGroupMetricChangeResponse.
        The start number of the week (starting from 1) to which the metric change applies, related to numberOfWeeks

        :param week_start_number: The week_start_number of this StaffingGroupMetricChangeResponse.
        :type: int
        """
        

        self._week_start_number = week_start_number

    @property
    def value(self) -> float:
        """
        Gets the value of this StaffingGroupMetricChangeResponse.
        The value of the metric

        :return: The value of this StaffingGroupMetricChangeResponse.
        :rtype: float
        """
        return self._value

    @value.setter
    def value(self, value: float) -> None:
        """
        Sets the value of this StaffingGroupMetricChangeResponse.
        The value of the metric

        :param value: The value of this StaffingGroupMetricChangeResponse.
        :type: float
        """
        

        self._value = value

    @property
    def metric(self) -> str:
        """
        Gets the metric of this StaffingGroupMetricChangeResponse.
        The metric which is going to be modified for the selected staffing groups

        :return: The metric of this StaffingGroupMetricChangeResponse.
        :rtype: str
        """
        return self._metric

    @metric.setter
    def metric(self, metric: str) -> None:
        """
        Sets the metric of this StaffingGroupMetricChangeResponse.
        The metric which is going to be modified for the selected staffing groups

        :param metric: The metric of this StaffingGroupMetricChangeResponse.
        :type: str
        """
        if isinstance(metric, int):
            metric = str(metric)
        allowed_values = ["StartingWeeklyFullTimeEquivalentCount", "NewHiresFullTimeEquivalentCount", "AttritionPercentage", "ShrinkagePercentage"]
        if metric.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for metric -> " + metric)
            self._metric = "outdated_sdk_version"
        else:
            self._metric = metric

    @property
    def notes(self) -> str:
        """
        Gets the notes of this StaffingGroupMetricChangeResponse.
        Notes about the staffing groups metric changes

        :return: The notes of this StaffingGroupMetricChangeResponse.
        :rtype: str
        """
        return self._notes

    @notes.setter
    def notes(self, notes: str) -> None:
        """
        Sets the notes of this StaffingGroupMetricChangeResponse.
        Notes about the staffing groups metric changes

        :param notes: The notes of this StaffingGroupMetricChangeResponse.
        :type: str
        """
        

        self._notes = notes

    @property
    def staffing_groups(self) -> List['StaffingGroupReference']:
        """
        Gets the staffing_groups of this StaffingGroupMetricChangeResponse.
        The staffing groups affected by the metric change

        :return: The staffing_groups of this StaffingGroupMetricChangeResponse.
        :rtype: list[StaffingGroupReference]
        """
        return self._staffing_groups

    @staffing_groups.setter
    def staffing_groups(self, staffing_groups: List['StaffingGroupReference']) -> None:
        """
        Sets the staffing_groups of this StaffingGroupMetricChangeResponse.
        The staffing groups affected by the metric change

        :param staffing_groups: The staffing_groups of this StaffingGroupMetricChangeResponse.
        :type: list[StaffingGroupReference]
        """
        

        self._staffing_groups = staffing_groups

    @property
    def created_by(self) -> 'UserReference':
        """
        Gets the created_by of this StaffingGroupMetricChangeResponse.
        The user who created the metric change

        :return: The created_by of this StaffingGroupMetricChangeResponse.
        :rtype: UserReference
        """
        return self._created_by

    @created_by.setter
    def created_by(self, created_by: 'UserReference') -> None:
        """
        Sets the created_by of this StaffingGroupMetricChangeResponse.
        The user who created the metric change

        :param created_by: The created_by of this StaffingGroupMetricChangeResponse.
        :type: UserReference
        """
        

        self._created_by = created_by

    @property
    def created_date(self) -> datetime:
        """
        Gets the created_date of this StaffingGroupMetricChangeResponse.
        The date the entity was created, in ISO-8601 format

        :return: The created_date of this StaffingGroupMetricChangeResponse.
        :rtype: datetime
        """
        return self._created_date

    @created_date.setter
    def created_date(self, created_date: datetime) -> None:
        """
        Sets the created_date of this StaffingGroupMetricChangeResponse.
        The date the entity was created, in ISO-8601 format

        :param created_date: The created_date of this StaffingGroupMetricChangeResponse.
        :type: datetime
        """
        

        self._created_date = created_date

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

