# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import SupportCenterImage

class SupportCenterHeroStyle(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        SupportCenterHeroStyle - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'background_color': 'str',
            'text_color': 'str',
            'image': 'SupportCenterImage'
        }

        self.attribute_map = {
            'background_color': 'backgroundColor',
            'text_color': 'textColor',
            'image': 'image'
        }

        self._background_color = None
        self._text_color = None
        self._image = None

    @property
    def background_color(self) -> str:
        """
        Gets the background_color of this SupportCenterHeroStyle.
        Background color for hero section, in hexadecimal format, eg #ffffff

        :return: The background_color of this SupportCenterHeroStyle.
        :rtype: str
        """
        return self._background_color

    @background_color.setter
    def background_color(self, background_color: str) -> None:
        """
        Sets the background_color of this SupportCenterHeroStyle.
        Background color for hero section, in hexadecimal format, eg #ffffff

        :param background_color: The background_color of this SupportCenterHeroStyle.
        :type: str
        """
        
        if not re.search('^#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$', background_color):
            raise ValueError("Invalid value for `background_color`, must be a follow pattern or equal to `/^#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$/`")


        self._background_color = background_color

    @property
    def text_color(self) -> str:
        """
        Gets the text_color of this SupportCenterHeroStyle.
        Text color for hero section, in hexadecimal format, eg #ffffff

        :return: The text_color of this SupportCenterHeroStyle.
        :rtype: str
        """
        return self._text_color

    @text_color.setter
    def text_color(self, text_color: str) -> None:
        """
        Sets the text_color of this SupportCenterHeroStyle.
        Text color for hero section, in hexadecimal format, eg #ffffff

        :param text_color: The text_color of this SupportCenterHeroStyle.
        :type: str
        """
        
        if not re.search('^#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$', text_color):
            raise ValueError("Invalid value for `text_color`, must be a follow pattern or equal to `/^#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$/`")


        self._text_color = text_color

    @property
    def image(self) -> 'SupportCenterImage':
        """
        Gets the image of this SupportCenterHeroStyle.
        Background image for hero section

        :return: The image of this SupportCenterHeroStyle.
        :rtype: SupportCenterImage
        """
        return self._image

    @image.setter
    def image(self, image: 'SupportCenterImage') -> None:
        """
        Sets the image of this SupportCenterHeroStyle.
        Background image for hero section

        :param image: The image of this SupportCenterHeroStyle.
        :type: SupportCenterImage
        """
        

        self._image = image

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

