# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import SupportCenterCompactCategoryModuleTemplate
    from . import SupportCenterDetailedCategoryModuleTemplate

class SupportCenterModuleSetting(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        SupportCenterModuleSetting - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'type': 'str',
            'enabled': 'bool',
            'compact_category_module_template': 'SupportCenterCompactCategoryModuleTemplate',
            'detailed_category_module_template': 'SupportCenterDetailedCategoryModuleTemplate'
        }

        self.attribute_map = {
            'type': 'type',
            'enabled': 'enabled',
            'compact_category_module_template': 'compactCategoryModuleTemplate',
            'detailed_category_module_template': 'detailedCategoryModuleTemplate'
        }

        self._type = None
        self._enabled = None
        self._compact_category_module_template = None
        self._detailed_category_module_template = None

    @property
    def type(self) -> str:
        """
        Gets the type of this SupportCenterModuleSetting.
        Screen module type

        :return: The type of this SupportCenterModuleSetting.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type: str) -> None:
        """
        Sets the type of this SupportCenterModuleSetting.
        Screen module type

        :param type: The type of this SupportCenterModuleSetting.
        :type: str
        """
        if isinstance(type, int):
            type = str(type)
        allowed_values = ["Search", "Categories", "FAQ", "Contact", "Results", "Article", "TopViewedArticles"]
        if type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for type -> " + type)
            self._type = "outdated_sdk_version"
        else:
            self._type = type

    @property
    def enabled(self) -> bool:
        """
        Gets the enabled of this SupportCenterModuleSetting.
        Whether or not knowledge portal (previously support center) screen module is enabled

        :return: The enabled of this SupportCenterModuleSetting.
        :rtype: bool
        """
        return self._enabled

    @enabled.setter
    def enabled(self, enabled: bool) -> None:
        """
        Sets the enabled of this SupportCenterModuleSetting.
        Whether or not knowledge portal (previously support center) screen module is enabled

        :param enabled: The enabled of this SupportCenterModuleSetting.
        :type: bool
        """
        

        self._enabled = enabled

    @property
    def compact_category_module_template(self) -> 'SupportCenterCompactCategoryModuleTemplate':
        """
        Gets the compact_category_module_template of this SupportCenterModuleSetting.
        Compact category module template

        :return: The compact_category_module_template of this SupportCenterModuleSetting.
        :rtype: SupportCenterCompactCategoryModuleTemplate
        """
        return self._compact_category_module_template

    @compact_category_module_template.setter
    def compact_category_module_template(self, compact_category_module_template: 'SupportCenterCompactCategoryModuleTemplate') -> None:
        """
        Sets the compact_category_module_template of this SupportCenterModuleSetting.
        Compact category module template

        :param compact_category_module_template: The compact_category_module_template of this SupportCenterModuleSetting.
        :type: SupportCenterCompactCategoryModuleTemplate
        """
        

        self._compact_category_module_template = compact_category_module_template

    @property
    def detailed_category_module_template(self) -> 'SupportCenterDetailedCategoryModuleTemplate':
        """
        Gets the detailed_category_module_template of this SupportCenterModuleSetting.
        Detailed category module template

        :return: The detailed_category_module_template of this SupportCenterModuleSetting.
        :rtype: SupportCenterDetailedCategoryModuleTemplate
        """
        return self._detailed_category_module_template

    @detailed_category_module_template.setter
    def detailed_category_module_template(self, detailed_category_module_template: 'SupportCenterDetailedCategoryModuleTemplate') -> None:
        """
        Sets the detailed_category_module_template of this SupportCenterModuleSetting.
        Detailed category module template

        :param detailed_category_module_template: The detailed_category_module_template of this SupportCenterModuleSetting.
        :type: SupportCenterDetailedCategoryModuleTemplate
        """
        

        self._detailed_category_module_template = detailed_category_module_template

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

