# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import AddressableEntityRef
    from . import ConversationReference
    from . import DomainEntityRef
    from . import QueueReference
    from . import SurveyErrorDetails
    from . import SurveyForm
    from . import SurveyScoringSet
    from . import Team

class Survey(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        Survey - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'conversation': 'ConversationReference',
            'survey_form': 'SurveyForm',
            'agent': 'DomainEntityRef',
            'status': 'str',
            'queue': 'QueueReference',
            'answers': 'SurveyScoringSet',
            'completed_date': 'datetime',
            'survey_error_details': 'SurveyErrorDetails',
            'agent_team': 'Team',
            'survey_type': 'str',
            'missing_required_answer': 'bool',
            'flow': 'AddressableEntityRef',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'conversation': 'conversation',
            'survey_form': 'surveyForm',
            'agent': 'agent',
            'status': 'status',
            'queue': 'queue',
            'answers': 'answers',
            'completed_date': 'completedDate',
            'survey_error_details': 'surveyErrorDetails',
            'agent_team': 'agentTeam',
            'survey_type': 'surveyType',
            'missing_required_answer': 'missingRequiredAnswer',
            'flow': 'flow',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._conversation = None
        self._survey_form = None
        self._agent = None
        self._status = None
        self._queue = None
        self._answers = None
        self._completed_date = None
        self._survey_error_details = None
        self._agent_team = None
        self._survey_type = None
        self._missing_required_answer = None
        self._flow = None
        self._self_uri = None

    @property
    def id(self) -> str:
        """
        Gets the id of this Survey.
        The globally unique identifier for the object.

        :return: The id of this Survey.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this Survey.
        The globally unique identifier for the object.

        :param id: The id of this Survey.
        :type: str
        """
        

        self._id = id

    @property
    def name(self) -> str:
        """
        Gets the name of this Survey.


        :return: The name of this Survey.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str) -> None:
        """
        Sets the name of this Survey.


        :param name: The name of this Survey.
        :type: str
        """
        

        self._name = name

    @property
    def conversation(self) -> 'ConversationReference':
        """
        Gets the conversation of this Survey.


        :return: The conversation of this Survey.
        :rtype: ConversationReference
        """
        return self._conversation

    @conversation.setter
    def conversation(self, conversation: 'ConversationReference') -> None:
        """
        Sets the conversation of this Survey.


        :param conversation: The conversation of this Survey.
        :type: ConversationReference
        """
        

        self._conversation = conversation

    @property
    def survey_form(self) -> 'SurveyForm':
        """
        Gets the survey_form of this Survey.
        Survey form used for this survey.

        :return: The survey_form of this Survey.
        :rtype: SurveyForm
        """
        return self._survey_form

    @survey_form.setter
    def survey_form(self, survey_form: 'SurveyForm') -> None:
        """
        Sets the survey_form of this Survey.
        Survey form used for this survey.

        :param survey_form: The survey_form of this Survey.
        :type: SurveyForm
        """
        

        self._survey_form = survey_form

    @property
    def agent(self) -> 'DomainEntityRef':
        """
        Gets the agent of this Survey.


        :return: The agent of this Survey.
        :rtype: DomainEntityRef
        """
        return self._agent

    @agent.setter
    def agent(self, agent: 'DomainEntityRef') -> None:
        """
        Sets the agent of this Survey.


        :param agent: The agent of this Survey.
        :type: DomainEntityRef
        """
        

        self._agent = agent

    @property
    def status(self) -> str:
        """
        Gets the status of this Survey.


        :return: The status of this Survey.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status: str) -> None:
        """
        Sets the status of this Survey.


        :param status: The status of this Survey.
        :type: str
        """
        if isinstance(status, int):
            status = str(status)
        allowed_values = ["Pending", "Sent", "InProgress", "Finished", "OptOut", "Error", "Expired"]
        if status.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for status -> " + status)
            self._status = "outdated_sdk_version"
        else:
            self._status = status

    @property
    def queue(self) -> 'QueueReference':
        """
        Gets the queue of this Survey.


        :return: The queue of this Survey.
        :rtype: QueueReference
        """
        return self._queue

    @queue.setter
    def queue(self, queue: 'QueueReference') -> None:
        """
        Sets the queue of this Survey.


        :param queue: The queue of this Survey.
        :type: QueueReference
        """
        

        self._queue = queue

    @property
    def answers(self) -> 'SurveyScoringSet':
        """
        Gets the answers of this Survey.


        :return: The answers of this Survey.
        :rtype: SurveyScoringSet
        """
        return self._answers

    @answers.setter
    def answers(self, answers: 'SurveyScoringSet') -> None:
        """
        Sets the answers of this Survey.


        :param answers: The answers of this Survey.
        :type: SurveyScoringSet
        """
        

        self._answers = answers

    @property
    def completed_date(self) -> datetime:
        """
        Gets the completed_date of this Survey.
        Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The completed_date of this Survey.
        :rtype: datetime
        """
        return self._completed_date

    @completed_date.setter
    def completed_date(self, completed_date: datetime) -> None:
        """
        Sets the completed_date of this Survey.
        Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param completed_date: The completed_date of this Survey.
        :type: datetime
        """
        

        self._completed_date = completed_date

    @property
    def survey_error_details(self) -> 'SurveyErrorDetails':
        """
        Gets the survey_error_details of this Survey.
        Additional information about what happened when the survey is in Error status.

        :return: The survey_error_details of this Survey.
        :rtype: SurveyErrorDetails
        """
        return self._survey_error_details

    @survey_error_details.setter
    def survey_error_details(self, survey_error_details: 'SurveyErrorDetails') -> None:
        """
        Sets the survey_error_details of this Survey.
        Additional information about what happened when the survey is in Error status.

        :param survey_error_details: The survey_error_details of this Survey.
        :type: SurveyErrorDetails
        """
        

        self._survey_error_details = survey_error_details

    @property
    def agent_team(self) -> 'Team':
        """
        Gets the agent_team of this Survey.
        The team that the agent belongs to

        :return: The agent_team of this Survey.
        :rtype: Team
        """
        return self._agent_team

    @agent_team.setter
    def agent_team(self, agent_team: 'Team') -> None:
        """
        Sets the agent_team of this Survey.
        The team that the agent belongs to

        :param agent_team: The agent_team of this Survey.
        :type: Team
        """
        

        self._agent_team = agent_team

    @property
    def survey_type(self) -> str:
        """
        Gets the survey_type of this Survey.
        Type of the survey

        :return: The survey_type of this Survey.
        :rtype: str
        """
        return self._survey_type

    @survey_type.setter
    def survey_type(self, survey_type: str) -> None:
        """
        Sets the survey_type of this Survey.
        Type of the survey

        :param survey_type: The survey_type of this Survey.
        :type: str
        """
        if isinstance(survey_type, int):
            survey_type = str(survey_type)
        allowed_values = ["Web", "Voice"]
        if survey_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for survey_type -> " + survey_type)
            self._survey_type = "outdated_sdk_version"
        else:
            self._survey_type = survey_type

    @property
    def missing_required_answer(self) -> bool:
        """
        Gets the missing_required_answer of this Survey.
        True if any of the required questions for the survey form have not been answered. Null if survey is not finished.

        :return: The missing_required_answer of this Survey.
        :rtype: bool
        """
        return self._missing_required_answer

    @missing_required_answer.setter
    def missing_required_answer(self, missing_required_answer: bool) -> None:
        """
        Sets the missing_required_answer of this Survey.
        True if any of the required questions for the survey form have not been answered. Null if survey is not finished.

        :param missing_required_answer: The missing_required_answer of this Survey.
        :type: bool
        """
        

        self._missing_required_answer = missing_required_answer

    @property
    def flow(self) -> 'AddressableEntityRef':
        """
        Gets the flow of this Survey.
        An Architect flow that executed in order to collect the answers for this survey.

        :return: The flow of this Survey.
        :rtype: AddressableEntityRef
        """
        return self._flow

    @flow.setter
    def flow(self, flow: 'AddressableEntityRef') -> None:
        """
        Sets the flow of this Survey.
        An Architect flow that executed in order to collect the answers for this survey.

        :param flow: The flow of this Survey.
        :type: AddressableEntityRef
        """
        

        self._flow = flow

    @property
    def self_uri(self) -> str:
        """
        Gets the self_uri of this Survey.
        The URI for this object

        :return: The self_uri of this Survey.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri: str) -> None:
        """
        Sets the self_uri of this Survey.
        The URI for this object

        :param self_uri: The self_uri of this Survey.
        :type: str
        """
        

        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

