# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import SurveyQuestion
    from . import VisibilityCondition

class SurveyQuestionGroup(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        SurveyQuestionGroup - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'context_id': 'str',
            'name': 'str',
            'type': 'str',
            'na_enabled': 'bool',
            'questions': 'list[SurveyQuestion]',
            'visibility_condition': 'VisibilityCondition'
        }

        self.attribute_map = {
            'id': 'id',
            'context_id': 'contextId',
            'name': 'name',
            'type': 'type',
            'na_enabled': 'naEnabled',
            'questions': 'questions',
            'visibility_condition': 'visibilityCondition'
        }

        self._id = None
        self._context_id = None
        self._name = None
        self._type = None
        self._na_enabled = None
        self._questions = None
        self._visibility_condition = None

    @property
    def id(self) -> str:
        """
        Gets the id of this SurveyQuestionGroup.


        :return: The id of this SurveyQuestionGroup.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this SurveyQuestionGroup.


        :param id: The id of this SurveyQuestionGroup.
        :type: str
        """
        

        self._id = id

    @property
    def context_id(self) -> str:
        """
        Gets the context_id of this SurveyQuestionGroup.
        An identifier for this question group that stays the same across versions of the form.

        :return: The context_id of this SurveyQuestionGroup.
        :rtype: str
        """
        return self._context_id

    @context_id.setter
    def context_id(self, context_id: str) -> None:
        """
        Sets the context_id of this SurveyQuestionGroup.
        An identifier for this question group that stays the same across versions of the form.

        :param context_id: The context_id of this SurveyQuestionGroup.
        :type: str
        """
        

        self._context_id = context_id

    @property
    def name(self) -> str:
        """
        Gets the name of this SurveyQuestionGroup.


        :return: The name of this SurveyQuestionGroup.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str) -> None:
        """
        Sets the name of this SurveyQuestionGroup.


        :param name: The name of this SurveyQuestionGroup.
        :type: str
        """
        

        self._name = name

    @property
    def type(self) -> str:
        """
        Gets the type of this SurveyQuestionGroup.


        :return: The type of this SurveyQuestionGroup.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type: str) -> None:
        """
        Sets the type of this SurveyQuestionGroup.


        :param type: The type of this SurveyQuestionGroup.
        :type: str
        """
        

        self._type = type

    @property
    def na_enabled(self) -> bool:
        """
        Gets the na_enabled of this SurveyQuestionGroup.


        :return: The na_enabled of this SurveyQuestionGroup.
        :rtype: bool
        """
        return self._na_enabled

    @na_enabled.setter
    def na_enabled(self, na_enabled: bool) -> None:
        """
        Sets the na_enabled of this SurveyQuestionGroup.


        :param na_enabled: The na_enabled of this SurveyQuestionGroup.
        :type: bool
        """
        

        self._na_enabled = na_enabled

    @property
    def questions(self) -> List['SurveyQuestion']:
        """
        Gets the questions of this SurveyQuestionGroup.


        :return: The questions of this SurveyQuestionGroup.
        :rtype: list[SurveyQuestion]
        """
        return self._questions

    @questions.setter
    def questions(self, questions: List['SurveyQuestion']) -> None:
        """
        Sets the questions of this SurveyQuestionGroup.


        :param questions: The questions of this SurveyQuestionGroup.
        :type: list[SurveyQuestion]
        """
        

        self._questions = questions

    @property
    def visibility_condition(self) -> 'VisibilityCondition':
        """
        Gets the visibility_condition of this SurveyQuestionGroup.


        :return: The visibility_condition of this SurveyQuestionGroup.
        :rtype: VisibilityCondition
        """
        return self._visibility_condition

    @visibility_condition.setter
    def visibility_condition(self, visibility_condition: 'VisibilityCondition') -> None:
        """
        Sets the visibility_condition of this SurveyQuestionGroup.


        :param visibility_condition: The visibility_condition of this SurveyQuestionGroup.
        :type: VisibilityCondition
        """
        

        self._visibility_condition = visibility_condition

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

