# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import PolicyAttribute
    from . import TargetAttributeValue

class TargetAttributes(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        TargetAttributes - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'base_attributes': 'list[PolicyAttribute]',
            'target_attributes': 'dict(str, TargetAttributeValue)'
        }

        self.attribute_map = {
            'base_attributes': 'baseAttributes',
            'target_attributes': 'targetAttributes'
        }

        self._base_attributes = None
        self._target_attributes = None

    @property
    def base_attributes(self) -> List['PolicyAttribute']:
        """
        Gets the base_attributes of this TargetAttributes.
        A set of base attributes which may be used in policies for any target.

        :return: The base_attributes of this TargetAttributes.
        :rtype: list[PolicyAttribute]
        """
        return self._base_attributes

    @base_attributes.setter
    def base_attributes(self, base_attributes: List['PolicyAttribute']) -> None:
        """
        Sets the base_attributes of this TargetAttributes.
        A set of base attributes which may be used in policies for any target.

        :param base_attributes: The base_attributes of this TargetAttributes.
        :type: list[PolicyAttribute]
        """
        

        self._base_attributes = base_attributes

    @property
    def target_attributes(self) -> Dict[str, 'TargetAttributeValue']:
        """
        Gets the target_attributes of this TargetAttributes.
        A map of policy targets to any additional attributes which are valid for that target.

        :return: The target_attributes of this TargetAttributes.
        :rtype: dict(str, TargetAttributeValue)
        """
        return self._target_attributes

    @target_attributes.setter
    def target_attributes(self, target_attributes: Dict[str, 'TargetAttributeValue']) -> None:
        """
        Sets the target_attributes of this TargetAttributes.
        A map of policy targets to any additional attributes which are valid for that target.

        :param target_attributes: The target_attributes of this TargetAttributes.
        :type: dict(str, TargetAttributeValue)
        """
        

        self._target_attributes = target_attributes

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

