# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import Duration

class TemporalUnit(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        TemporalUnit - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'duration_estimated': 'bool',
            'duration': 'Duration',
            'time_based': 'bool',
            'date_based': 'bool'
        }

        self.attribute_map = {
            'duration_estimated': 'durationEstimated',
            'duration': 'duration',
            'time_based': 'timeBased',
            'date_based': 'dateBased'
        }

        self._duration_estimated = None
        self._duration = None
        self._time_based = None
        self._date_based = None

    @property
    def duration_estimated(self) -> bool:
        """
        Gets the duration_estimated of this TemporalUnit.


        :return: The duration_estimated of this TemporalUnit.
        :rtype: bool
        """
        return self._duration_estimated

    @duration_estimated.setter
    def duration_estimated(self, duration_estimated: bool) -> None:
        """
        Sets the duration_estimated of this TemporalUnit.


        :param duration_estimated: The duration_estimated of this TemporalUnit.
        :type: bool
        """
        

        self._duration_estimated = duration_estimated

    @property
    def duration(self) -> 'Duration':
        """
        Gets the duration of this TemporalUnit.


        :return: The duration of this TemporalUnit.
        :rtype: Duration
        """
        return self._duration

    @duration.setter
    def duration(self, duration: 'Duration') -> None:
        """
        Sets the duration of this TemporalUnit.


        :param duration: The duration of this TemporalUnit.
        :type: Duration
        """
        

        self._duration = duration

    @property
    def time_based(self) -> bool:
        """
        Gets the time_based of this TemporalUnit.


        :return: The time_based of this TemporalUnit.
        :rtype: bool
        """
        return self._time_based

    @time_based.setter
    def time_based(self, time_based: bool) -> None:
        """
        Sets the time_based of this TemporalUnit.


        :param time_based: The time_based of this TemporalUnit.
        :type: bool
        """
        

        self._time_based = time_based

    @property
    def date_based(self) -> bool:
        """
        Gets the date_based of this TemporalUnit.


        :return: The date_based of this TemporalUnit.
        :rtype: bool
        """
        return self._date_based

    @date_based.setter
    def date_based(self, date_based: bool) -> None:
        """
        Sets the date_based of this TemporalUnit.


        :param date_based: The date_based of this TemporalUnit.
        :type: bool
        """
        

        self._date_based = date_based

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

