# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import ErrorBody
    from . import TestExecutionOperationResult

class TestExecutionResult(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        TestExecutionResult - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'operations': 'list[TestExecutionOperationResult]',
            'error': 'ErrorBody',
            'final_result': 'object',
            'success': 'bool'
        }

        self.attribute_map = {
            'operations': 'operations',
            'error': 'error',
            'final_result': 'finalResult',
            'success': 'success'
        }

        self._operations = None
        self._error = None
        self._final_result = None
        self._success = None

    @property
    def operations(self) -> List['TestExecutionOperationResult']:
        """
        Gets the operations of this TestExecutionResult.
        Execution operations performed as part of the test

        :return: The operations of this TestExecutionResult.
        :rtype: list[TestExecutionOperationResult]
        """
        return self._operations

    @operations.setter
    def operations(self, operations: List['TestExecutionOperationResult']) -> None:
        """
        Sets the operations of this TestExecutionResult.
        Execution operations performed as part of the test

        :param operations: The operations of this TestExecutionResult.
        :type: list[TestExecutionOperationResult]
        """
        

        self._operations = operations

    @property
    def error(self) -> 'ErrorBody':
        """
        Gets the error of this TestExecutionResult.
        The final error encountered during the test that resulted in test failure

        :return: The error of this TestExecutionResult.
        :rtype: ErrorBody
        """
        return self._error

    @error.setter
    def error(self, error: 'ErrorBody') -> None:
        """
        Sets the error of this TestExecutionResult.
        The final error encountered during the test that resulted in test failure

        :param error: The error of this TestExecutionResult.
        :type: ErrorBody
        """
        

        self._error = error

    @property
    def final_result(self) -> object:
        """
        Gets the final_result of this TestExecutionResult.
        The final result of the test. This is the response that would be returned during normal action execution

        :return: The final_result of this TestExecutionResult.
        :rtype: object
        """
        return self._final_result

    @final_result.setter
    def final_result(self, final_result: object) -> None:
        """
        Sets the final_result of this TestExecutionResult.
        The final result of the test. This is the response that would be returned during normal action execution

        :param final_result: The final_result of this TestExecutionResult.
        :type: object
        """
        

        self._final_result = final_result

    @property
    def success(self) -> bool:
        """
        Gets the success of this TestExecutionResult.
        Indicates whether or not the test was a success

        :return: The success of this TestExecutionResult.
        :rtype: bool
        """
        return self._success

    @success.setter
    def success(self, success: bool) -> None:
        """
        Sets the success of this TestExecutionResult.
        Indicates whether or not the test was a success

        :param success: The success of this TestExecutionResult.
        :type: bool
        """
        

        self._success = success

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

