# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import TestModeTrigger

class TestMatchesEventOperation(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        TestMatchesEventOperation - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'name': 'str',
            'step': 'int',
            'matched_triggers': 'list[TestModeTrigger]',
            'unmatched_triggers': 'list[TestModeTrigger]'
        }

        self.attribute_map = {
            'name': 'name',
            'step': 'step',
            'matched_triggers': 'matchedTriggers',
            'unmatched_triggers': 'unmatchedTriggers'
        }

        self._name = None
        self._step = None
        self._matched_triggers = None
        self._unmatched_triggers = None

    @property
    def name(self) -> str:
        """
        Gets the name of this TestMatchesEventOperation.
        The name of the processing step

        :return: The name of this TestMatchesEventOperation.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str) -> None:
        """
        Sets the name of this TestMatchesEventOperation.
        The name of the processing step

        :param name: The name of this TestMatchesEventOperation.
        :type: str
        """
        

        self._name = name

    @property
    def step(self) -> int:
        """
        Gets the step of this TestMatchesEventOperation.
        The number of the processing step

        :return: The step of this TestMatchesEventOperation.
        :rtype: int
        """
        return self._step

    @step.setter
    def step(self, step: int) -> None:
        """
        Sets the step of this TestMatchesEventOperation.
        The number of the processing step

        :param step: The step of this TestMatchesEventOperation.
        :type: int
        """
        

        self._step = step

    @property
    def matched_triggers(self) -> List['TestModeTrigger']:
        """
        Gets the matched_triggers of this TestMatchesEventOperation.
        Triggers that matched

        :return: The matched_triggers of this TestMatchesEventOperation.
        :rtype: list[TestModeTrigger]
        """
        return self._matched_triggers

    @matched_triggers.setter
    def matched_triggers(self, matched_triggers: List['TestModeTrigger']) -> None:
        """
        Sets the matched_triggers of this TestMatchesEventOperation.
        Triggers that matched

        :param matched_triggers: The matched_triggers of this TestMatchesEventOperation.
        :type: list[TestModeTrigger]
        """
        

        self._matched_triggers = matched_triggers

    @property
    def unmatched_triggers(self) -> List['TestModeTrigger']:
        """
        Gets the unmatched_triggers of this TestMatchesEventOperation.
        Triggers that did not match

        :return: The unmatched_triggers of this TestMatchesEventOperation.
        :rtype: list[TestModeTrigger]
        """
        return self._unmatched_triggers

    @unmatched_triggers.setter
    def unmatched_triggers(self, unmatched_triggers: List['TestModeTrigger']) -> None:
        """
        Sets the unmatched_triggers of this TestMatchesEventOperation.
        Triggers that did not match

        :param unmatched_triggers: The unmatched_triggers of this TestMatchesEventOperation.
        :type: list[TestModeTrigger]
        """
        

        self._unmatched_triggers = unmatched_triggers

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

