# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import TestMatchesOperation
    from . import TestSchemaOperation
    from . import TestTargetOperation

class TestModeResults(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        TestModeResults - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'schema_validation': 'TestSchemaOperation',
            'target_validation': 'TestTargetOperation',
            'json_path_validation': 'TestMatchesOperation',
            'trigger_matches': 'bool'
        }

        self.attribute_map = {
            'schema_validation': 'schemaValidation',
            'target_validation': 'targetValidation',
            'json_path_validation': 'jsonPathValidation',
            'trigger_matches': 'triggerMatches'
        }

        self._schema_validation = None
        self._target_validation = None
        self._json_path_validation = None
        self._trigger_matches = None

    @property
    def schema_validation(self) -> 'TestSchemaOperation':
        """
        Gets the schema_validation of this TestModeResults.
        Information about the validation of the schema of the event body passed in to test mode

        :return: The schema_validation of this TestModeResults.
        :rtype: TestSchemaOperation
        """
        return self._schema_validation

    @schema_validation.setter
    def schema_validation(self, schema_validation: 'TestSchemaOperation') -> None:
        """
        Sets the schema_validation of this TestModeResults.
        Information about the validation of the schema of the event body passed in to test mode

        :param schema_validation: The schema_validation of this TestModeResults.
        :type: TestSchemaOperation
        """
        

        self._schema_validation = schema_validation

    @property
    def target_validation(self) -> 'TestTargetOperation':
        """
        Gets the target_validation of this TestModeResults.
        Information about the validation of the trigger target

        :return: The target_validation of this TestModeResults.
        :rtype: TestTargetOperation
        """
        return self._target_validation

    @target_validation.setter
    def target_validation(self, target_validation: 'TestTargetOperation') -> None:
        """
        Sets the target_validation of this TestModeResults.
        Information about the validation of the trigger target

        :param target_validation: The target_validation of this TestModeResults.
        :type: TestTargetOperation
        """
        

        self._target_validation = target_validation

    @property
    def json_path_validation(self) -> 'TestMatchesOperation':
        """
        Gets the json_path_validation of this TestModeResults.
        Information about the json path matching criteria

        :return: The json_path_validation of this TestModeResults.
        :rtype: TestMatchesOperation
        """
        return self._json_path_validation

    @json_path_validation.setter
    def json_path_validation(self, json_path_validation: 'TestMatchesOperation') -> None:
        """
        Sets the json_path_validation of this TestModeResults.
        Information about the json path matching criteria

        :param json_path_validation: The json_path_validation of this TestModeResults.
        :type: TestMatchesOperation
        """
        

        self._json_path_validation = json_path_validation

    @property
    def trigger_matches(self) -> bool:
        """
        Gets the trigger_matches of this TestModeResults.
        Whether the trigger would have matched on the provided event body

        :return: The trigger_matches of this TestModeResults.
        :rtype: bool
        """
        return self._trigger_matches

    @trigger_matches.setter
    def trigger_matches(self, trigger_matches: bool) -> None:
        """
        Sets the trigger_matches of this TestModeResults.
        Whether the trigger would have matched on the provided event body

        :param trigger_matches: The trigger_matches of this TestModeResults.
        :type: bool
        """
        

        self._trigger_matches = trigger_matches

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

