# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import TestTopicPhraseTopic
    from . import TranscriptsFilters

class TestTopicPhraseJobRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        TestTopicPhraseJobRequest - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'topic': 'TestTopicPhraseTopic',
            'transcripts_filters': 'TranscriptsFilters'
        }

        self.attribute_map = {
            'topic': 'topic',
            'transcripts_filters': 'transcriptsFilters'
        }

        self._topic = None
        self._transcripts_filters = None

    @property
    def topic(self) -> 'TestTopicPhraseTopic':
        """
        Gets the topic of this TestTopicPhraseJobRequest.
        The topic to test

        :return: The topic of this TestTopicPhraseJobRequest.
        :rtype: TestTopicPhraseTopic
        """
        return self._topic

    @topic.setter
    def topic(self, topic: 'TestTopicPhraseTopic') -> None:
        """
        Sets the topic of this TestTopicPhraseJobRequest.
        The topic to test

        :param topic: The topic of this TestTopicPhraseJobRequest.
        :type: TestTopicPhraseTopic
        """
        

        self._topic = topic

    @property
    def transcripts_filters(self) -> 'TranscriptsFilters':
        """
        Gets the transcripts_filters of this TestTopicPhraseJobRequest.
        The transcripts filters

        :return: The transcripts_filters of this TestTopicPhraseJobRequest.
        :rtype: TranscriptsFilters
        """
        return self._transcripts_filters

    @transcripts_filters.setter
    def transcripts_filters(self, transcripts_filters: 'TranscriptsFilters') -> None:
        """
        Sets the transcripts_filters of this TestTopicPhraseJobRequest.
        The transcripts filters

        :param transcripts_filters: The transcripts_filters of this TestTopicPhraseJobRequest.
        :type: TranscriptsFilters
        """
        

        self._transcripts_filters = transcripts_filters

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

