# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import TestTopicPhrasePhrase

class TestTopicPhraseTopic(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        TestTopicPhraseTopic - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'phrase': 'TestTopicPhrasePhrase',
            'strictness': 'str',
            'dialect': 'str',
            'participants': 'str'
        }

        self.attribute_map = {
            'phrase': 'phrase',
            'strictness': 'strictness',
            'dialect': 'dialect',
            'participants': 'participants'
        }

        self._phrase = None
        self._strictness = None
        self._dialect = None
        self._participants = None

    @property
    def phrase(self) -> 'TestTopicPhrasePhrase':
        """
        Gets the phrase of this TestTopicPhraseTopic.
        The topic phrase to test

        :return: The phrase of this TestTopicPhraseTopic.
        :rtype: TestTopicPhrasePhrase
        """
        return self._phrase

    @phrase.setter
    def phrase(self, phrase: 'TestTopicPhrasePhrase') -> None:
        """
        Sets the phrase of this TestTopicPhraseTopic.
        The topic phrase to test

        :param phrase: The phrase of this TestTopicPhraseTopic.
        :type: TestTopicPhrasePhrase
        """
        

        self._phrase = phrase

    @property
    def strictness(self) -> str:
        """
        Gets the strictness of this TestTopicPhraseTopic.
        The topic strictness, default value is 72

        :return: The strictness of this TestTopicPhraseTopic.
        :rtype: str
        """
        return self._strictness

    @strictness.setter
    def strictness(self, strictness: str) -> None:
        """
        Sets the strictness of this TestTopicPhraseTopic.
        The topic strictness, default value is 72

        :param strictness: The strictness of this TestTopicPhraseTopic.
        :type: str
        """
        if isinstance(strictness, int):
            strictness = str(strictness)
        allowed_values = ["1", "55", "65", "72", "85", "90"]
        if strictness.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for strictness -> " + strictness)
            self._strictness = "outdated_sdk_version"
        else:
            self._strictness = strictness

    @property
    def dialect(self) -> str:
        """
        Gets the dialect of this TestTopicPhraseTopic.
        The topic dialect, default value is en-US

        :return: The dialect of this TestTopicPhraseTopic.
        :rtype: str
        """
        return self._dialect

    @dialect.setter
    def dialect(self, dialect: str) -> None:
        """
        Sets the dialect of this TestTopicPhraseTopic.
        The topic dialect, default value is en-US

        :param dialect: The dialect of this TestTopicPhraseTopic.
        :type: str
        """
        

        self._dialect = dialect

    @property
    def participants(self) -> str:
        """
        Gets the participants of this TestTopicPhraseTopic.
        The topic participants, default value is both

        :return: The participants of this TestTopicPhraseTopic.
        :rtype: str
        """
        return self._participants

    @participants.setter
    def participants(self, participants: str) -> None:
        """
        Sets the participants of this TestTopicPhraseTopic.
        The topic participants, default value is both

        :param participants: The participants of this TestTopicPhraseTopic.
        :type: str
        """
        if isinstance(participants, int):
            participants = str(participants)
        allowed_values = ["External", "Internal", "All"]
        if participants.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for participants -> " + participants)
            self._participants = "outdated_sdk_version"
        else:
            self._participants = participants

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

