# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class TimeAndDateSubConditionRange(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        TimeAndDateSubConditionRange - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'min': 'str',
            'max': 'str',
            'in_set': 'list[str]'
        }

        self.attribute_map = {
            'min': 'min',
            'max': 'max',
            'in_set': 'inSet'
        }

        self._min = None
        self._max = None
        self._in_set = None

    @property
    def min(self) -> str:
        """
        Gets the min of this TimeAndDateSubConditionRange.
        The minimum value of the range. Required for the operator BETWEEN. Format depends on type: timeOfDay: HH:mm, dayOfWeek: 1-7 (Monday-Sunday), dayOfMonth: 1-31, specificDate: yyyy-MM-dd (if includeYear=true) or MM-dd (if includeYear=false).

        :return: The min of this TimeAndDateSubConditionRange.
        :rtype: str
        """
        return self._min

    @min.setter
    def min(self, min: str) -> None:
        """
        Sets the min of this TimeAndDateSubConditionRange.
        The minimum value of the range. Required for the operator BETWEEN. Format depends on type: timeOfDay: HH:mm, dayOfWeek: 1-7 (Monday-Sunday), dayOfMonth: 1-31, specificDate: yyyy-MM-dd (if includeYear=true) or MM-dd (if includeYear=false).

        :param min: The min of this TimeAndDateSubConditionRange.
        :type: str
        """
        

        self._min = min

    @property
    def max(self) -> str:
        """
        Gets the max of this TimeAndDateSubConditionRange.
        The maximum value of the range. Required for the operator BETWEEN. Format follows the same rules as 'min'.

        :return: The max of this TimeAndDateSubConditionRange.
        :rtype: str
        """
        return self._max

    @max.setter
    def max(self, max: str) -> None:
        """
        Sets the max of this TimeAndDateSubConditionRange.
        The maximum value of the range. Required for the operator BETWEEN. Format follows the same rules as 'min'.

        :param max: The max of this TimeAndDateSubConditionRange.
        :type: str
        """
        

        self._max = max

    @property
    def in_set(self) -> List[str]:
        """
        Gets the in_set of this TimeAndDateSubConditionRange.
        A set of values that the date/ time data should be in. Required for the IN operator. Format depends on type: dayOfWeek: 1-7 (Monday-Sunday), dayOfMonth: 1-31, and/ or LAST_DAY, ODD_DAY, EVEN_DAY,specificDate: yyyy-MM-dd (if includeYear=true) or MM-dd (if includeYear=false).

        :return: The in_set of this TimeAndDateSubConditionRange.
        :rtype: list[str]
        """
        return self._in_set

    @in_set.setter
    def in_set(self, in_set: List[str]) -> None:
        """
        Sets the in_set of this TimeAndDateSubConditionRange.
        A set of values that the date/ time data should be in. Required for the IN operator. Format depends on type: dayOfWeek: 1-7 (Monday-Sunday), dayOfMonth: 1-31, and/ or LAST_DAY, ODD_DAY, EVEN_DAY,specificDate: yyyy-MM-dd (if includeYear=true) or MM-dd (if includeYear=false).

        :param in_set: The in_set of this TimeAndDateSubConditionRange.
        :type: list[str]
        """
        

        self._in_set = in_set

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

