# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class TimeInterval(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        TimeInterval - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'months': 'int',
            'weeks': 'int',
            'days': 'int',
            'hours': 'int'
        }

        self.attribute_map = {
            'months': 'months',
            'weeks': 'weeks',
            'days': 'days',
            'hours': 'hours'
        }

        self._months = None
        self._weeks = None
        self._days = None
        self._hours = None

    @property
    def months(self) -> int:
        """
        Gets the months of this TimeInterval.


        :return: The months of this TimeInterval.
        :rtype: int
        """
        return self._months

    @months.setter
    def months(self, months: int) -> None:
        """
        Sets the months of this TimeInterval.


        :param months: The months of this TimeInterval.
        :type: int
        """
        

        self._months = months

    @property
    def weeks(self) -> int:
        """
        Gets the weeks of this TimeInterval.


        :return: The weeks of this TimeInterval.
        :rtype: int
        """
        return self._weeks

    @weeks.setter
    def weeks(self, weeks: int) -> None:
        """
        Sets the weeks of this TimeInterval.


        :param weeks: The weeks of this TimeInterval.
        :type: int
        """
        

        self._weeks = weeks

    @property
    def days(self) -> int:
        """
        Gets the days of this TimeInterval.


        :return: The days of this TimeInterval.
        :rtype: int
        """
        return self._days

    @days.setter
    def days(self, days: int) -> None:
        """
        Sets the days of this TimeInterval.


        :param days: The days of this TimeInterval.
        :type: int
        """
        

        self._days = days

    @property
    def hours(self) -> int:
        """
        Gets the hours of this TimeInterval.


        :return: The hours of this TimeInterval.
        :rtype: int
        """
        return self._hours

    @hours.setter
    def hours(self, hours: int) -> None:
        """
        Sets the hours of this TimeInterval.


        :param hours: The hours of this TimeInterval.
        :type: int
        """
        

        self._hours = hours

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

