# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import UserReference

class TimeOffRequestNotification(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        TimeOffRequestNotification - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'time_off_request_id': 'str',
            'user': 'UserReference',
            'is_full_day_request': 'bool',
            'status': 'str',
            'partial_day_start_date_times': 'list[datetime]',
            'full_day_management_unit_dates': 'list[str]'
        }

        self.attribute_map = {
            'time_off_request_id': 'timeOffRequestId',
            'user': 'user',
            'is_full_day_request': 'isFullDayRequest',
            'status': 'status',
            'partial_day_start_date_times': 'partialDayStartDateTimes',
            'full_day_management_unit_dates': 'fullDayManagementUnitDates'
        }

        self._time_off_request_id = None
        self._user = None
        self._is_full_day_request = None
        self._status = None
        self._partial_day_start_date_times = None
        self._full_day_management_unit_dates = None

    @property
    def time_off_request_id(self) -> str:
        """
        Gets the time_off_request_id of this TimeOffRequestNotification.
        The ID of this time off request

        :return: The time_off_request_id of this TimeOffRequestNotification.
        :rtype: str
        """
        return self._time_off_request_id

    @time_off_request_id.setter
    def time_off_request_id(self, time_off_request_id: str) -> None:
        """
        Sets the time_off_request_id of this TimeOffRequestNotification.
        The ID of this time off request

        :param time_off_request_id: The time_off_request_id of this TimeOffRequestNotification.
        :type: str
        """
        

        self._time_off_request_id = time_off_request_id

    @property
    def user(self) -> 'UserReference':
        """
        Gets the user of this TimeOffRequestNotification.
        The user associated with this time off request

        :return: The user of this TimeOffRequestNotification.
        :rtype: UserReference
        """
        return self._user

    @user.setter
    def user(self, user: 'UserReference') -> None:
        """
        Sets the user of this TimeOffRequestNotification.
        The user associated with this time off request

        :param user: The user of this TimeOffRequestNotification.
        :type: UserReference
        """
        

        self._user = user

    @property
    def is_full_day_request(self) -> bool:
        """
        Gets the is_full_day_request of this TimeOffRequestNotification.
        Whether this is a full day request (false means partial day)

        :return: The is_full_day_request of this TimeOffRequestNotification.
        :rtype: bool
        """
        return self._is_full_day_request

    @is_full_day_request.setter
    def is_full_day_request(self, is_full_day_request: bool) -> None:
        """
        Sets the is_full_day_request of this TimeOffRequestNotification.
        Whether this is a full day request (false means partial day)

        :param is_full_day_request: The is_full_day_request of this TimeOffRequestNotification.
        :type: bool
        """
        

        self._is_full_day_request = is_full_day_request

    @property
    def status(self) -> str:
        """
        Gets the status of this TimeOffRequestNotification.
        The status of this time off request

        :return: The status of this TimeOffRequestNotification.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status: str) -> None:
        """
        Sets the status of this TimeOffRequestNotification.
        The status of this time off request

        :param status: The status of this TimeOffRequestNotification.
        :type: str
        """
        if isinstance(status, int):
            status = str(status)
        allowed_values = ["PENDING", "APPROVED", "DENIED", "CANCELED"]
        if status.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for status -> " + status)
            self._status = "outdated_sdk_version"
        else:
            self._status = status

    @property
    def partial_day_start_date_times(self) -> List[datetime]:
        """
        Gets the partial_day_start_date_times of this TimeOffRequestNotification.
        A set of start date-times in ISO-8601 format for partial day requests.  Will be not empty if isFullDayRequest == false

        :return: The partial_day_start_date_times of this TimeOffRequestNotification.
        :rtype: list[datetime]
        """
        return self._partial_day_start_date_times

    @partial_day_start_date_times.setter
    def partial_day_start_date_times(self, partial_day_start_date_times: List[datetime]) -> None:
        """
        Sets the partial_day_start_date_times of this TimeOffRequestNotification.
        A set of start date-times in ISO-8601 format for partial day requests.  Will be not empty if isFullDayRequest == false

        :param partial_day_start_date_times: The partial_day_start_date_times of this TimeOffRequestNotification.
        :type: list[datetime]
        """
        

        self._partial_day_start_date_times = partial_day_start_date_times

    @property
    def full_day_management_unit_dates(self) -> List[str]:
        """
        Gets the full_day_management_unit_dates of this TimeOffRequestNotification.
        A set of dates in yyyy-MM-dd format.  Should be interpreted in the management unit's configured time zone.  Will be not empty if isFullDayRequest == true

        :return: The full_day_management_unit_dates of this TimeOffRequestNotification.
        :rtype: list[str]
        """
        return self._full_day_management_unit_dates

    @full_day_management_unit_dates.setter
    def full_day_management_unit_dates(self, full_day_management_unit_dates: List[str]) -> None:
        """
        Sets the full_day_management_unit_dates of this TimeOffRequestNotification.
        A set of dates in yyyy-MM-dd format.  Should be interpreted in the management unit's configured time zone.  Will be not empty if isFullDayRequest == true

        :param full_day_management_unit_dates: The full_day_management_unit_dates of this TimeOffRequestNotification.
        :type: list[str]
        """
        

        self._full_day_management_unit_dates = full_day_management_unit_dates

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

