# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class Touchpoint(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        Touchpoint - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'conversation_id': 'str',
            'agent_id': 'str',
            'associated_value': 'float',
            'media_type': 'str',
            'created_date': 'datetime'
        }

        self.attribute_map = {
            'conversation_id': 'conversationId',
            'agent_id': 'agentId',
            'associated_value': 'associatedValue',
            'media_type': 'mediaType',
            'created_date': 'createdDate'
        }

        self._conversation_id = None
        self._agent_id = None
        self._associated_value = None
        self._media_type = None
        self._created_date = None

    @property
    def conversation_id(self) -> str:
        """
        Gets the conversation_id of this Touchpoint.
        ID of conversation.

        :return: The conversation_id of this Touchpoint.
        :rtype: str
        """
        return self._conversation_id

    @conversation_id.setter
    def conversation_id(self, conversation_id: str) -> None:
        """
        Sets the conversation_id of this Touchpoint.
        ID of conversation.

        :param conversation_id: The conversation_id of this Touchpoint.
        :type: str
        """
        

        self._conversation_id = conversation_id

    @property
    def agent_id(self) -> str:
        """
        Gets the agent_id of this Touchpoint.
        ID of agent.

        :return: The agent_id of this Touchpoint.
        :rtype: str
        """
        return self._agent_id

    @agent_id.setter
    def agent_id(self, agent_id: str) -> None:
        """
        Sets the agent_id of this Touchpoint.
        ID of agent.

        :param agent_id: The agent_id of this Touchpoint.
        :type: str
        """
        

        self._agent_id = agent_id

    @property
    def associated_value(self) -> float:
        """
        Gets the associated_value of this Touchpoint.
        The value attributed to this touchpoint.

        :return: The associated_value of this Touchpoint.
        :rtype: float
        """
        return self._associated_value

    @associated_value.setter
    def associated_value(self, associated_value: float) -> None:
        """
        Sets the associated_value of this Touchpoint.
        The value attributed to this touchpoint.

        :param associated_value: The associated_value of this Touchpoint.
        :type: float
        """
        

        self._associated_value = associated_value

    @property
    def media_type(self) -> str:
        """
        Gets the media_type of this Touchpoint.
        Media Type of the touchpoint; allowed values are Email, Message and Voice.

        :return: The media_type of this Touchpoint.
        :rtype: str
        """
        return self._media_type

    @media_type.setter
    def media_type(self, media_type: str) -> None:
        """
        Sets the media_type of this Touchpoint.
        Media Type of the touchpoint; allowed values are Email, Message and Voice.

        :param media_type: The media_type of this Touchpoint.
        :type: str
        """
        if isinstance(media_type, int):
            media_type = str(media_type)
        allowed_values = ["Email", "Message", "Voice"]
        if media_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for media_type -> " + media_type)
            self._media_type = "outdated_sdk_version"
        else:
            self._media_type = media_type

    @property
    def created_date(self) -> datetime:
        """
        Gets the created_date of this Touchpoint.
        Date conversation happened. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The created_date of this Touchpoint.
        :rtype: datetime
        """
        return self._created_date

    @created_date.setter
    def created_date(self, created_date: datetime) -> None:
        """
        Sets the created_date of this Touchpoint.
        Date conversation happened. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param created_date: The created_date of this Touchpoint.
        :type: datetime
        """
        

        self._created_date = created_date

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

