# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import TranscriptionTopicTranscriptAlternative

class TranscriptionTopicTranscriptResult(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        TranscriptionTopicTranscriptResult - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'utterance_id': 'str',
            'is_final': 'bool',
            'channel': 'str',
            'alternatives': 'list[TranscriptionTopicTranscriptAlternative]',
            'agent_assistant_id': 'str',
            'engine_provider': 'str',
            'engine_id': 'str',
            'engine_name': 'str',
            'dialect': 'str',
            'speech_text_analytics_program_id': 'str',
            'agent_assist_enabled': 'bool',
            'voice_transcription_enabled': 'bool'
        }

        self.attribute_map = {
            'utterance_id': 'utteranceId',
            'is_final': 'isFinal',
            'channel': 'channel',
            'alternatives': 'alternatives',
            'agent_assistant_id': 'agentAssistantId',
            'engine_provider': 'engineProvider',
            'engine_id': 'engineId',
            'engine_name': 'engineName',
            'dialect': 'dialect',
            'speech_text_analytics_program_id': 'speechTextAnalyticsProgramId',
            'agent_assist_enabled': 'agentAssistEnabled',
            'voice_transcription_enabled': 'voiceTranscriptionEnabled'
        }

        self._utterance_id = None
        self._is_final = None
        self._channel = None
        self._alternatives = None
        self._agent_assistant_id = None
        self._engine_provider = None
        self._engine_id = None
        self._engine_name = None
        self._dialect = None
        self._speech_text_analytics_program_id = None
        self._agent_assist_enabled = None
        self._voice_transcription_enabled = None

    @property
    def utterance_id(self) -> str:
        """
        Gets the utterance_id of this TranscriptionTopicTranscriptResult.


        :return: The utterance_id of this TranscriptionTopicTranscriptResult.
        :rtype: str
        """
        return self._utterance_id

    @utterance_id.setter
    def utterance_id(self, utterance_id: str) -> None:
        """
        Sets the utterance_id of this TranscriptionTopicTranscriptResult.


        :param utterance_id: The utterance_id of this TranscriptionTopicTranscriptResult.
        :type: str
        """
        

        self._utterance_id = utterance_id

    @property
    def is_final(self) -> bool:
        """
        Gets the is_final of this TranscriptionTopicTranscriptResult.


        :return: The is_final of this TranscriptionTopicTranscriptResult.
        :rtype: bool
        """
        return self._is_final

    @is_final.setter
    def is_final(self, is_final: bool) -> None:
        """
        Sets the is_final of this TranscriptionTopicTranscriptResult.


        :param is_final: The is_final of this TranscriptionTopicTranscriptResult.
        :type: bool
        """
        

        self._is_final = is_final

    @property
    def channel(self) -> str:
        """
        Gets the channel of this TranscriptionTopicTranscriptResult.


        :return: The channel of this TranscriptionTopicTranscriptResult.
        :rtype: str
        """
        return self._channel

    @channel.setter
    def channel(self, channel: str) -> None:
        """
        Sets the channel of this TranscriptionTopicTranscriptResult.


        :param channel: The channel of this TranscriptionTopicTranscriptResult.
        :type: str
        """
        if isinstance(channel, int):
            channel = str(channel)
        allowed_values = ["UNKNOWN", "INTERNAL", "EXTERNAL", "BOTH"]
        if channel.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for channel -> " + channel)
            self._channel = "outdated_sdk_version"
        else:
            self._channel = channel

    @property
    def alternatives(self) -> List['TranscriptionTopicTranscriptAlternative']:
        """
        Gets the alternatives of this TranscriptionTopicTranscriptResult.


        :return: The alternatives of this TranscriptionTopicTranscriptResult.
        :rtype: list[TranscriptionTopicTranscriptAlternative]
        """
        return self._alternatives

    @alternatives.setter
    def alternatives(self, alternatives: List['TranscriptionTopicTranscriptAlternative']) -> None:
        """
        Sets the alternatives of this TranscriptionTopicTranscriptResult.


        :param alternatives: The alternatives of this TranscriptionTopicTranscriptResult.
        :type: list[TranscriptionTopicTranscriptAlternative]
        """
        

        self._alternatives = alternatives

    @property
    def agent_assistant_id(self) -> str:
        """
        Gets the agent_assistant_id of this TranscriptionTopicTranscriptResult.


        :return: The agent_assistant_id of this TranscriptionTopicTranscriptResult.
        :rtype: str
        """
        return self._agent_assistant_id

    @agent_assistant_id.setter
    def agent_assistant_id(self, agent_assistant_id: str) -> None:
        """
        Sets the agent_assistant_id of this TranscriptionTopicTranscriptResult.


        :param agent_assistant_id: The agent_assistant_id of this TranscriptionTopicTranscriptResult.
        :type: str
        """
        

        self._agent_assistant_id = agent_assistant_id

    @property
    def engine_provider(self) -> str:
        """
        Gets the engine_provider of this TranscriptionTopicTranscriptResult.


        :return: The engine_provider of this TranscriptionTopicTranscriptResult.
        :rtype: str
        """
        return self._engine_provider

    @engine_provider.setter
    def engine_provider(self, engine_provider: str) -> None:
        """
        Sets the engine_provider of this TranscriptionTopicTranscriptResult.


        :param engine_provider: The engine_provider of this TranscriptionTopicTranscriptResult.
        :type: str
        """
        

        self._engine_provider = engine_provider

    @property
    def engine_id(self) -> str:
        """
        Gets the engine_id of this TranscriptionTopicTranscriptResult.


        :return: The engine_id of this TranscriptionTopicTranscriptResult.
        :rtype: str
        """
        return self._engine_id

    @engine_id.setter
    def engine_id(self, engine_id: str) -> None:
        """
        Sets the engine_id of this TranscriptionTopicTranscriptResult.


        :param engine_id: The engine_id of this TranscriptionTopicTranscriptResult.
        :type: str
        """
        

        self._engine_id = engine_id

    @property
    def engine_name(self) -> str:
        """
        Gets the engine_name of this TranscriptionTopicTranscriptResult.


        :return: The engine_name of this TranscriptionTopicTranscriptResult.
        :rtype: str
        """
        return self._engine_name

    @engine_name.setter
    def engine_name(self, engine_name: str) -> None:
        """
        Sets the engine_name of this TranscriptionTopicTranscriptResult.


        :param engine_name: The engine_name of this TranscriptionTopicTranscriptResult.
        :type: str
        """
        

        self._engine_name = engine_name

    @property
    def dialect(self) -> str:
        """
        Gets the dialect of this TranscriptionTopicTranscriptResult.


        :return: The dialect of this TranscriptionTopicTranscriptResult.
        :rtype: str
        """
        return self._dialect

    @dialect.setter
    def dialect(self, dialect: str) -> None:
        """
        Sets the dialect of this TranscriptionTopicTranscriptResult.


        :param dialect: The dialect of this TranscriptionTopicTranscriptResult.
        :type: str
        """
        

        self._dialect = dialect

    @property
    def speech_text_analytics_program_id(self) -> str:
        """
        Gets the speech_text_analytics_program_id of this TranscriptionTopicTranscriptResult.


        :return: The speech_text_analytics_program_id of this TranscriptionTopicTranscriptResult.
        :rtype: str
        """
        return self._speech_text_analytics_program_id

    @speech_text_analytics_program_id.setter
    def speech_text_analytics_program_id(self, speech_text_analytics_program_id: str) -> None:
        """
        Sets the speech_text_analytics_program_id of this TranscriptionTopicTranscriptResult.


        :param speech_text_analytics_program_id: The speech_text_analytics_program_id of this TranscriptionTopicTranscriptResult.
        :type: str
        """
        

        self._speech_text_analytics_program_id = speech_text_analytics_program_id

    @property
    def agent_assist_enabled(self) -> bool:
        """
        Gets the agent_assist_enabled of this TranscriptionTopicTranscriptResult.


        :return: The agent_assist_enabled of this TranscriptionTopicTranscriptResult.
        :rtype: bool
        """
        return self._agent_assist_enabled

    @agent_assist_enabled.setter
    def agent_assist_enabled(self, agent_assist_enabled: bool) -> None:
        """
        Sets the agent_assist_enabled of this TranscriptionTopicTranscriptResult.


        :param agent_assist_enabled: The agent_assist_enabled of this TranscriptionTopicTranscriptResult.
        :type: bool
        """
        

        self._agent_assist_enabled = agent_assist_enabled

    @property
    def voice_transcription_enabled(self) -> bool:
        """
        Gets the voice_transcription_enabled of this TranscriptionTopicTranscriptResult.


        :return: The voice_transcription_enabled of this TranscriptionTopicTranscriptResult.
        :rtype: bool
        """
        return self._voice_transcription_enabled

    @voice_transcription_enabled.setter
    def voice_transcription_enabled(self, voice_transcription_enabled: bool) -> None:
        """
        Sets the voice_transcription_enabled of this TranscriptionTopicTranscriptResult.


        :param voice_transcription_enabled: The voice_transcription_enabled of this TranscriptionTopicTranscriptResult.
        :type: bool
        """
        

        self._voice_transcription_enabled = voice_transcription_enabled

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

