# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class TranscriptsFilters(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        TranscriptsFilters - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'media_type': 'str',
            'start_time_ms': 'int',
            'end_time_ms': 'int',
            'queues': 'list[str]',
            'flows': 'list[str]'
        }

        self.attribute_map = {
            'media_type': 'mediaType',
            'start_time_ms': 'startTimeMs',
            'end_time_ms': 'endTimeMs',
            'queues': 'queues',
            'flows': 'flows'
        }

        self._media_type = None
        self._start_time_ms = None
        self._end_time_ms = None
        self._queues = None
        self._flows = None

    @property
    def media_type(self) -> str:
        """
        Gets the media_type of this TranscriptsFilters.
        The media type of the transcripts, default value is all 

        :return: The media_type of this TranscriptsFilters.
        :rtype: str
        """
        return self._media_type

    @media_type.setter
    def media_type(self, media_type: str) -> None:
        """
        Sets the media_type of this TranscriptsFilters.
        The media type of the transcripts, default value is all 

        :param media_type: The media_type of this TranscriptsFilters.
        :type: str
        """
        if isinstance(media_type, int):
            media_type = str(media_type)
        allowed_values = ["call", "message", "email", "chat", "callback", "all"]
        if media_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for media_type -> " + media_type)
            self._media_type = "outdated_sdk_version"
        else:
            self._media_type = media_type

    @property
    def start_time_ms(self) -> int:
        """
        Gets the start_time_ms of this TranscriptsFilters.
        start time to filter by, default value is 7 days into the past

        :return: The start_time_ms of this TranscriptsFilters.
        :rtype: int
        """
        return self._start_time_ms

    @start_time_ms.setter
    def start_time_ms(self, start_time_ms: int) -> None:
        """
        Sets the start_time_ms of this TranscriptsFilters.
        start time to filter by, default value is 7 days into the past

        :param start_time_ms: The start_time_ms of this TranscriptsFilters.
        :type: int
        """
        

        self._start_time_ms = start_time_ms

    @property
    def end_time_ms(self) -> int:
        """
        Gets the end_time_ms of this TranscriptsFilters.
        end time to filter by, default value is current time

        :return: The end_time_ms of this TranscriptsFilters.
        :rtype: int
        """
        return self._end_time_ms

    @end_time_ms.setter
    def end_time_ms(self, end_time_ms: int) -> None:
        """
        Sets the end_time_ms of this TranscriptsFilters.
        end time to filter by, default value is current time

        :param end_time_ms: The end_time_ms of this TranscriptsFilters.
        :type: int
        """
        

        self._end_time_ms = end_time_ms

    @property
    def queues(self) -> List[str]:
        """
        Gets the queues of this TranscriptsFilters.
        list of queues ids to filter by

        :return: The queues of this TranscriptsFilters.
        :rtype: list[str]
        """
        return self._queues

    @queues.setter
    def queues(self, queues: List[str]) -> None:
        """
        Sets the queues of this TranscriptsFilters.
        list of queues ids to filter by

        :param queues: The queues of this TranscriptsFilters.
        :type: list[str]
        """
        

        self._queues = queues

    @property
    def flows(self) -> List[str]:
        """
        Gets the flows of this TranscriptsFilters.
        list of flows ids to filter by

        :return: The flows of this TranscriptsFilters.
        :rtype: list[str]
        """
        return self._flows

    @flows.setter
    def flows(self, flows: List[str]) -> None:
        """
        Sets the flows of this TranscriptsFilters.
        list of flows ids to filter by

        :param flows: The flows of this TranscriptsFilters.
        :type: list[str]
        """
        

        self._flows = flows

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

