# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class TransferToQueueRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        TransferToQueueRequest - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'transfer_type': 'str',
            'keep_internal_message_alive': 'bool',
            'queue_id': 'str',
            'queue_name': 'str'
        }

        self.attribute_map = {
            'transfer_type': 'transferType',
            'keep_internal_message_alive': 'keepInternalMessageAlive',
            'queue_id': 'queueId',
            'queue_name': 'queueName'
        }

        self._transfer_type = None
        self._keep_internal_message_alive = None
        self._queue_id = None
        self._queue_name = None

    @property
    def transfer_type(self) -> str:
        """
        Gets the transfer_type of this TransferToQueueRequest.
        The type of transfer to perform. Attended, where the initiating agent maintains ownership of the conversation until the intended recipient accepts the transfer, or Unattended, where the initiating agent immediately disconnects. Default is Unattended.

        :return: The transfer_type of this TransferToQueueRequest.
        :rtype: str
        """
        return self._transfer_type

    @transfer_type.setter
    def transfer_type(self, transfer_type: str) -> None:
        """
        Sets the transfer_type of this TransferToQueueRequest.
        The type of transfer to perform. Attended, where the initiating agent maintains ownership of the conversation until the intended recipient accepts the transfer, or Unattended, where the initiating agent immediately disconnects. Default is Unattended.

        :param transfer_type: The transfer_type of this TransferToQueueRequest.
        :type: str
        """
        if isinstance(transfer_type, int):
            transfer_type = str(transfer_type)
        allowed_values = ["Attended", "Unattended"]
        if transfer_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for transfer_type -> " + transfer_type)
            self._transfer_type = "outdated_sdk_version"
        else:
            self._transfer_type = transfer_type

    @property
    def keep_internal_message_alive(self) -> bool:
        """
        Gets the keep_internal_message_alive of this TransferToQueueRequest.
        If true, the digital internal message will NOT be terminated.

        :return: The keep_internal_message_alive of this TransferToQueueRequest.
        :rtype: bool
        """
        return self._keep_internal_message_alive

    @keep_internal_message_alive.setter
    def keep_internal_message_alive(self, keep_internal_message_alive: bool) -> None:
        """
        Sets the keep_internal_message_alive of this TransferToQueueRequest.
        If true, the digital internal message will NOT be terminated.

        :param keep_internal_message_alive: The keep_internal_message_alive of this TransferToQueueRequest.
        :type: bool
        """
        

        self._keep_internal_message_alive = keep_internal_message_alive

    @property
    def queue_id(self) -> str:
        """
        Gets the queue_id of this TransferToQueueRequest.
        The id of the queue.

        :return: The queue_id of this TransferToQueueRequest.
        :rtype: str
        """
        return self._queue_id

    @queue_id.setter
    def queue_id(self, queue_id: str) -> None:
        """
        Sets the queue_id of this TransferToQueueRequest.
        The id of the queue.

        :param queue_id: The queue_id of this TransferToQueueRequest.
        :type: str
        """
        

        self._queue_id = queue_id

    @property
    def queue_name(self) -> str:
        """
        Gets the queue_name of this TransferToQueueRequest.
        The name of the queue.

        :return: The queue_name of this TransferToQueueRequest.
        :rtype: str
        """
        return self._queue_name

    @queue_name.setter
    def queue_name(self, queue_name: str) -> None:
        """
        Sets the queue_name of this TransferToQueueRequest.
        The name of the queue.

        :param queue_name: The queue_name of this TransferToQueueRequest.
        :type: str
        """
        

        self._queue_name = queue_name

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

