# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import TrunkInstanceTopicTrunkErrorInfo

class TrunkInstanceTopicTrunkMetricsRegisters(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        TrunkInstanceTopicTrunkMetricsRegisters - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'proxy_address': 'str',
            'register_state': 'bool',
            'register_state_time': 'datetime',
            'error_info': 'TrunkInstanceTopicTrunkErrorInfo'
        }

        self.attribute_map = {
            'proxy_address': 'proxyAddress',
            'register_state': 'registerState',
            'register_state_time': 'registerStateTime',
            'error_info': 'errorInfo'
        }

        self._proxy_address = None
        self._register_state = None
        self._register_state_time = None
        self._error_info = None

    @property
    def proxy_address(self) -> str:
        """
        Gets the proxy_address of this TrunkInstanceTopicTrunkMetricsRegisters.


        :return: The proxy_address of this TrunkInstanceTopicTrunkMetricsRegisters.
        :rtype: str
        """
        return self._proxy_address

    @proxy_address.setter
    def proxy_address(self, proxy_address: str) -> None:
        """
        Sets the proxy_address of this TrunkInstanceTopicTrunkMetricsRegisters.


        :param proxy_address: The proxy_address of this TrunkInstanceTopicTrunkMetricsRegisters.
        :type: str
        """
        

        self._proxy_address = proxy_address

    @property
    def register_state(self) -> bool:
        """
        Gets the register_state of this TrunkInstanceTopicTrunkMetricsRegisters.


        :return: The register_state of this TrunkInstanceTopicTrunkMetricsRegisters.
        :rtype: bool
        """
        return self._register_state

    @register_state.setter
    def register_state(self, register_state: bool) -> None:
        """
        Sets the register_state of this TrunkInstanceTopicTrunkMetricsRegisters.


        :param register_state: The register_state of this TrunkInstanceTopicTrunkMetricsRegisters.
        :type: bool
        """
        

        self._register_state = register_state

    @property
    def register_state_time(self) -> datetime:
        """
        Gets the register_state_time of this TrunkInstanceTopicTrunkMetricsRegisters.


        :return: The register_state_time of this TrunkInstanceTopicTrunkMetricsRegisters.
        :rtype: datetime
        """
        return self._register_state_time

    @register_state_time.setter
    def register_state_time(self, register_state_time: datetime) -> None:
        """
        Sets the register_state_time of this TrunkInstanceTopicTrunkMetricsRegisters.


        :param register_state_time: The register_state_time of this TrunkInstanceTopicTrunkMetricsRegisters.
        :type: datetime
        """
        

        self._register_state_time = register_state_time

    @property
    def error_info(self) -> 'TrunkInstanceTopicTrunkErrorInfo':
        """
        Gets the error_info of this TrunkInstanceTopicTrunkMetricsRegisters.


        :return: The error_info of this TrunkInstanceTopicTrunkMetricsRegisters.
        :rtype: TrunkInstanceTopicTrunkErrorInfo
        """
        return self._error_info

    @error_info.setter
    def error_info(self, error_info: 'TrunkInstanceTopicTrunkErrorInfo') -> None:
        """
        Sets the error_info of this TrunkInstanceTopicTrunkMetricsRegisters.


        :param error_info: The error_info of this TrunkInstanceTopicTrunkMetricsRegisters.
        :type: TrunkInstanceTopicTrunkErrorInfo
        """
        

        self._error_info = error_info

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

