# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class TrunkRecordingEnabledCount(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        TrunkRecordingEnabledCount - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'enabled_count': 'int',
            'disabled_count': 'int'
        }

        self.attribute_map = {
            'enabled_count': 'enabledCount',
            'disabled_count': 'disabledCount'
        }

        self._enabled_count = None
        self._disabled_count = None

    @property
    def enabled_count(self) -> int:
        """
        Gets the enabled_count of this TrunkRecordingEnabledCount.
        The amount of trunks that have recording enabled

        :return: The enabled_count of this TrunkRecordingEnabledCount.
        :rtype: int
        """
        return self._enabled_count

    @enabled_count.setter
    def enabled_count(self, enabled_count: int) -> None:
        """
        Sets the enabled_count of this TrunkRecordingEnabledCount.
        The amount of trunks that have recording enabled

        :param enabled_count: The enabled_count of this TrunkRecordingEnabledCount.
        :type: int
        """
        

        self._enabled_count = enabled_count

    @property
    def disabled_count(self) -> int:
        """
        Gets the disabled_count of this TrunkRecordingEnabledCount.
        The amount of trunks that do not have recording enabled

        :return: The disabled_count of this TrunkRecordingEnabledCount.
        :rtype: int
        """
        return self._disabled_count

    @disabled_count.setter
    def disabled_count(self, disabled_count: int) -> None:
        """
        Sets the disabled_count of this TrunkRecordingEnabledCount.
        The amount of trunks that do not have recording enabled

        :param disabled_count: The disabled_count of this TrunkRecordingEnabledCount.
        :type: int
        """
        

        self._disabled_count = disabled_count

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

