# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import TweetUsage

class TwitterDataHistoricalTweetResponse(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        TwitterDataHistoricalTweetResponse - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'matching_tweets': 'int',
            'previous_number_of_days': 'int',
            'usage_statistics': 'TweetUsage'
        }

        self.attribute_map = {
            'matching_tweets': 'matchingTweets',
            'previous_number_of_days': 'previousNumberOfDays',
            'usage_statistics': 'usageStatistics'
        }

        self._matching_tweets = None
        self._previous_number_of_days = None
        self._usage_statistics = None

    @property
    def matching_tweets(self) -> int:
        """
        Gets the matching_tweets of this TwitterDataHistoricalTweetResponse.
        The count of matching tweets using the searchTerms.

        :return: The matching_tweets of this TwitterDataHistoricalTweetResponse.
        :rtype: int
        """
        return self._matching_tweets

    @matching_tweets.setter
    def matching_tweets(self, matching_tweets: int) -> None:
        """
        Sets the matching_tweets of this TwitterDataHistoricalTweetResponse.
        The count of matching tweets using the searchTerms.

        :param matching_tweets: The matching_tweets of this TwitterDataHistoricalTweetResponse.
        :type: int
        """
        

        self._matching_tweets = matching_tweets

    @property
    def previous_number_of_days(self) -> int:
        """
        Gets the previous_number_of_days of this TwitterDataHistoricalTweetResponse.
        The number of days used for the query

        :return: The previous_number_of_days of this TwitterDataHistoricalTweetResponse.
        :rtype: int
        """
        return self._previous_number_of_days

    @previous_number_of_days.setter
    def previous_number_of_days(self, previous_number_of_days: int) -> None:
        """
        Sets the previous_number_of_days of this TwitterDataHistoricalTweetResponse.
        The number of days used for the query

        :param previous_number_of_days: The previous_number_of_days of this TwitterDataHistoricalTweetResponse.
        :type: int
        """
        

        self._previous_number_of_days = previous_number_of_days

    @property
    def usage_statistics(self) -> 'TweetUsage':
        """
        Gets the usage_statistics of this TwitterDataHistoricalTweetResponse.
        The tweet usage of the org

        :return: The usage_statistics of this TwitterDataHistoricalTweetResponse.
        :rtype: TweetUsage
        """
        return self._usage_statistics

    @usage_statistics.setter
    def usage_statistics(self, usage_statistics: 'TweetUsage') -> None:
        """
        Sets the usage_statistics of this TwitterDataHistoricalTweetResponse.
        The tweet usage of the org

        :param usage_statistics: The usage_statistics of this TwitterDataHistoricalTweetResponse.
        :type: TweetUsage
        """
        

        self._usage_statistics = usage_statistics

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

