# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import CapacityPlanMetadata
    from . import ValueWrapperBuShortTermForecastReference

class UpdateCapacityPlanRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        UpdateCapacityPlanRequest - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'name': 'str',
            'description': 'str',
            'start_business_unit_date': 'date',
            'end_business_unit_date': 'date',
            'forecast': 'ValueWrapperBuShortTermForecastReference',
            'full_time_equivalent_weekly_hours': 'float',
            'use_latest_planning_group_staffing_group_association': 'bool',
            'metadata': 'CapacityPlanMetadata'
        }

        self.attribute_map = {
            'name': 'name',
            'description': 'description',
            'start_business_unit_date': 'startBusinessUnitDate',
            'end_business_unit_date': 'endBusinessUnitDate',
            'forecast': 'forecast',
            'full_time_equivalent_weekly_hours': 'fullTimeEquivalentWeeklyHours',
            'use_latest_planning_group_staffing_group_association': 'useLatestPlanningGroupStaffingGroupAssociation',
            'metadata': 'metadata'
        }

        self._name = None
        self._description = None
        self._start_business_unit_date = None
        self._end_business_unit_date = None
        self._forecast = None
        self._full_time_equivalent_weekly_hours = None
        self._use_latest_planning_group_staffing_group_association = None
        self._metadata = None

    @property
    def name(self) -> str:
        """
        Gets the name of this UpdateCapacityPlanRequest.
        The name of the capacity plan

        :return: The name of this UpdateCapacityPlanRequest.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str) -> None:
        """
        Sets the name of this UpdateCapacityPlanRequest.
        The name of the capacity plan

        :param name: The name of this UpdateCapacityPlanRequest.
        :type: str
        """
        

        self._name = name

    @property
    def description(self) -> str:
        """
        Gets the description of this UpdateCapacityPlanRequest.
        Description of the capacity plan

        :return: The description of this UpdateCapacityPlanRequest.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description: str) -> None:
        """
        Sets the description of this UpdateCapacityPlanRequest.
        Description of the capacity plan

        :param description: The description of this UpdateCapacityPlanRequest.
        :type: str
        """
        

        self._description = description

    @property
    def start_business_unit_date(self) -> date:
        """
        Gets the start_business_unit_date of this UpdateCapacityPlanRequest.
        The start date for the capacity plan relative to the business unit time zone in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :return: The start_business_unit_date of this UpdateCapacityPlanRequest.
        :rtype: date
        """
        return self._start_business_unit_date

    @start_business_unit_date.setter
    def start_business_unit_date(self, start_business_unit_date: date) -> None:
        """
        Sets the start_business_unit_date of this UpdateCapacityPlanRequest.
        The start date for the capacity plan relative to the business unit time zone in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :param start_business_unit_date: The start_business_unit_date of this UpdateCapacityPlanRequest.
        :type: date
        """
        

        self._start_business_unit_date = start_business_unit_date

    @property
    def end_business_unit_date(self) -> date:
        """
        Gets the end_business_unit_date of this UpdateCapacityPlanRequest.
        The end date for the capacity plan relative to the business unit time zone in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :return: The end_business_unit_date of this UpdateCapacityPlanRequest.
        :rtype: date
        """
        return self._end_business_unit_date

    @end_business_unit_date.setter
    def end_business_unit_date(self, end_business_unit_date: date) -> None:
        """
        Sets the end_business_unit_date of this UpdateCapacityPlanRequest.
        The end date for the capacity plan relative to the business unit time zone in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :param end_business_unit_date: The end_business_unit_date of this UpdateCapacityPlanRequest.
        :type: date
        """
        

        self._end_business_unit_date = end_business_unit_date

    @property
    def forecast(self) -> 'ValueWrapperBuShortTermForecastReference':
        """
        Gets the forecast of this UpdateCapacityPlanRequest.
        The selected forecast for this capacity plan

        :return: The forecast of this UpdateCapacityPlanRequest.
        :rtype: ValueWrapperBuShortTermForecastReference
        """
        return self._forecast

    @forecast.setter
    def forecast(self, forecast: 'ValueWrapperBuShortTermForecastReference') -> None:
        """
        Sets the forecast of this UpdateCapacityPlanRequest.
        The selected forecast for this capacity plan

        :param forecast: The forecast of this UpdateCapacityPlanRequest.
        :type: ValueWrapperBuShortTermForecastReference
        """
        

        self._forecast = forecast

    @property
    def full_time_equivalent_weekly_hours(self) -> float:
        """
        Gets the full_time_equivalent_weekly_hours of this UpdateCapacityPlanRequest.
        The weekly hours used to calculate full time equivalent agents

        :return: The full_time_equivalent_weekly_hours of this UpdateCapacityPlanRequest.
        :rtype: float
        """
        return self._full_time_equivalent_weekly_hours

    @full_time_equivalent_weekly_hours.setter
    def full_time_equivalent_weekly_hours(self, full_time_equivalent_weekly_hours: float) -> None:
        """
        Sets the full_time_equivalent_weekly_hours of this UpdateCapacityPlanRequest.
        The weekly hours used to calculate full time equivalent agents

        :param full_time_equivalent_weekly_hours: The full_time_equivalent_weekly_hours of this UpdateCapacityPlanRequest.
        :type: float
        """
        

        self._full_time_equivalent_weekly_hours = full_time_equivalent_weekly_hours

    @property
    def use_latest_planning_group_staffing_group_association(self) -> bool:
        """
        Gets the use_latest_planning_group_staffing_group_association of this UpdateCapacityPlanRequest.
        Whether to use latest staffing group to planning group association

        :return: The use_latest_planning_group_staffing_group_association of this UpdateCapacityPlanRequest.
        :rtype: bool
        """
        return self._use_latest_planning_group_staffing_group_association

    @use_latest_planning_group_staffing_group_association.setter
    def use_latest_planning_group_staffing_group_association(self, use_latest_planning_group_staffing_group_association: bool) -> None:
        """
        Sets the use_latest_planning_group_staffing_group_association of this UpdateCapacityPlanRequest.
        Whether to use latest staffing group to planning group association

        :param use_latest_planning_group_staffing_group_association: The use_latest_planning_group_staffing_group_association of this UpdateCapacityPlanRequest.
        :type: bool
        """
        

        self._use_latest_planning_group_staffing_group_association = use_latest_planning_group_staffing_group_association

    @property
    def metadata(self) -> 'CapacityPlanMetadata':
        """
        Gets the metadata of this UpdateCapacityPlanRequest.
        The metadata of this capacity plan

        :return: The metadata of this UpdateCapacityPlanRequest.
        :rtype: CapacityPlanMetadata
        """
        return self._metadata

    @metadata.setter
    def metadata(self, metadata: 'CapacityPlanMetadata') -> None:
        """
        Sets the metadata of this UpdateCapacityPlanRequest.
        The metadata of this capacity plan

        :param metadata: The metadata of this UpdateCapacityPlanRequest.
        :type: CapacityPlanMetadata
        """
        

        self._metadata = metadata

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

