# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import GuideVersionResources
    from . import Variable

class UpdateGuideVersion(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        UpdateGuideVersion - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'instruction': 'str',
            'variables': 'list[Variable]',
            'resources': 'GuideVersionResources'
        }

        self.attribute_map = {
            'instruction': 'instruction',
            'variables': 'variables',
            'resources': 'resources'
        }

        self._instruction = None
        self._variables = None
        self._resources = None

    @property
    def instruction(self) -> str:
        """
        Gets the instruction of this UpdateGuideVersion.
        The instruction given to this version of the guide, for how it should behave when interacting with a User.

        :return: The instruction of this UpdateGuideVersion.
        :rtype: str
        """
        return self._instruction

    @instruction.setter
    def instruction(self, instruction: str) -> None:
        """
        Sets the instruction of this UpdateGuideVersion.
        The instruction given to this version of the guide, for how it should behave when interacting with a User.

        :param instruction: The instruction of this UpdateGuideVersion.
        :type: str
        """
        

        self._instruction = instruction

    @property
    def variables(self) -> List['Variable']:
        """
        Gets the variables of this UpdateGuideVersion.
        The variables associated with this version of the guide. Includes input variables (provided) and output variables (captured during execution).

        :return: The variables of this UpdateGuideVersion.
        :rtype: list[Variable]
        """
        return self._variables

    @variables.setter
    def variables(self, variables: List['Variable']) -> None:
        """
        Sets the variables of this UpdateGuideVersion.
        The variables associated with this version of the guide. Includes input variables (provided) and output variables (captured during execution).

        :param variables: The variables of this UpdateGuideVersion.
        :type: list[Variable]
        """
        

        self._variables = variables

    @property
    def resources(self) -> 'GuideVersionResources':
        """
        Gets the resources of this UpdateGuideVersion.
        The resources associated with this version of the guide.

        :return: The resources of this UpdateGuideVersion.
        :rtype: GuideVersionResources
        """
        return self._resources

    @resources.setter
    def resources(self, resources: 'GuideVersionResources') -> None:
        """
        Sets the resources of this UpdateGuideVersion.
        The resources associated with this version of the guide.

        :param resources: The resources of this UpdateGuideVersion.
        :type: GuideVersionResources
        """
        

        self._resources = resources

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

