# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import UpdateScheduleUploadSchema

class UpdateScheduleUploadResponse(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        UpdateScheduleUploadResponse - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'upload_key': 'str',
            'url': 'str',
            'headers': 'dict(str, str)',
            'upload_body_schema': 'UpdateScheduleUploadSchema'
        }

        self.attribute_map = {
            'upload_key': 'uploadKey',
            'url': 'url',
            'headers': 'headers',
            'upload_body_schema': 'uploadBodySchema'
        }

        self._upload_key = None
        self._url = None
        self._headers = None
        self._upload_body_schema = None

    @property
    def upload_key(self) -> str:
        """
        Gets the upload_key of this UpdateScheduleUploadResponse.
        The key to pass to the secondary request to start processing of the upload

        :return: The upload_key of this UpdateScheduleUploadResponse.
        :rtype: str
        """
        return self._upload_key

    @upload_key.setter
    def upload_key(self, upload_key: str) -> None:
        """
        Sets the upload_key of this UpdateScheduleUploadResponse.
        The key to pass to the secondary request to start processing of the upload

        :param upload_key: The upload_key of this UpdateScheduleUploadResponse.
        :type: str
        """
        

        self._upload_key = upload_key

    @property
    def url(self) -> str:
        """
        Gets the url of this UpdateScheduleUploadResponse.
        The url to which to PUT the upload body

        :return: The url of this UpdateScheduleUploadResponse.
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url: str) -> None:
        """
        Sets the url of this UpdateScheduleUploadResponse.
        The url to which to PUT the upload body

        :param url: The url of this UpdateScheduleUploadResponse.
        :type: str
        """
        

        self._url = url

    @property
    def headers(self) -> Dict[str, str]:
        """
        Gets the headers of this UpdateScheduleUploadResponse.
        Required headers for the PUT request to the url

        :return: The headers of this UpdateScheduleUploadResponse.
        :rtype: dict(str, str)
        """
        return self._headers

    @headers.setter
    def headers(self, headers: Dict[str, str]) -> None:
        """
        Sets the headers of this UpdateScheduleUploadResponse.
        Required headers for the PUT request to the url

        :param headers: The headers of this UpdateScheduleUploadResponse.
        :type: dict(str, str)
        """
        

        self._headers = headers

    @property
    def upload_body_schema(self) -> 'UpdateScheduleUploadSchema':
        """
        Gets the upload_body_schema of this UpdateScheduleUploadResponse.
        Always null. Defines the schema of the json body to be PUT to the url. The json body should be gzip encoded before uploading

        :return: The upload_body_schema of this UpdateScheduleUploadResponse.
        :rtype: UpdateScheduleUploadSchema
        """
        return self._upload_body_schema

    @upload_body_schema.setter
    def upload_body_schema(self, upload_body_schema: 'UpdateScheduleUploadSchema') -> None:
        """
        Sets the upload_body_schema of this UpdateScheduleUploadResponse.
        Always null. Defines the schema of the json body to be PUT to the url. The json body should be gzip encoded before uploading

        :param upload_body_schema: The upload_body_schema of this UpdateScheduleUploadResponse.
        :type: UpdateScheduleUploadSchema
        """
        

        self._upload_body_schema = upload_body_schema

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

