# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import Geolocation
    from . import OutOfOffice
    from . import RoutingStatus
    from . import UserAuthorization
    from . import UserConversationSummary
    from . import UserPresence
    from . import UserStations

class UserExpands(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        UserExpands - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'routing_status': 'RoutingStatus',
            'presence': 'UserPresence',
            'integration_presence': 'UserPresence',
            'conversation_summary': 'UserConversationSummary',
            'out_of_office': 'OutOfOffice',
            'geolocation': 'Geolocation',
            'station': 'UserStations',
            'authorization': 'UserAuthorization'
        }

        self.attribute_map = {
            'routing_status': 'routingStatus',
            'presence': 'presence',
            'integration_presence': 'integrationPresence',
            'conversation_summary': 'conversationSummary',
            'out_of_office': 'outOfOffice',
            'geolocation': 'geolocation',
            'station': 'station',
            'authorization': 'authorization'
        }

        self._routing_status = None
        self._presence = None
        self._integration_presence = None
        self._conversation_summary = None
        self._out_of_office = None
        self._geolocation = None
        self._station = None
        self._authorization = None

    @property
    def routing_status(self) -> 'RoutingStatus':
        """
        Gets the routing_status of this UserExpands.
        ACD routing status

        :return: The routing_status of this UserExpands.
        :rtype: RoutingStatus
        """
        return self._routing_status

    @routing_status.setter
    def routing_status(self, routing_status: 'RoutingStatus') -> None:
        """
        Sets the routing_status of this UserExpands.
        ACD routing status

        :param routing_status: The routing_status of this UserExpands.
        :type: RoutingStatus
        """
        

        self._routing_status = routing_status

    @property
    def presence(self) -> 'UserPresence':
        """
        Gets the presence of this UserExpands.
        Active presence

        :return: The presence of this UserExpands.
        :rtype: UserPresence
        """
        return self._presence

    @presence.setter
    def presence(self, presence: 'UserPresence') -> None:
        """
        Sets the presence of this UserExpands.
        Active presence

        :param presence: The presence of this UserExpands.
        :type: UserPresence
        """
        

        self._presence = presence

    @property
    def integration_presence(self) -> 'UserPresence':
        """
        Gets the integration_presence of this UserExpands.
        Active 3rd party presence

        :return: The integration_presence of this UserExpands.
        :rtype: UserPresence
        """
        return self._integration_presence

    @integration_presence.setter
    def integration_presence(self, integration_presence: 'UserPresence') -> None:
        """
        Sets the integration_presence of this UserExpands.
        Active 3rd party presence

        :param integration_presence: The integration_presence of this UserExpands.
        :type: UserPresence
        """
        

        self._integration_presence = integration_presence

    @property
    def conversation_summary(self) -> 'UserConversationSummary':
        """
        Gets the conversation_summary of this UserExpands.
        Summary of conversion statistics for conversation types.

        :return: The conversation_summary of this UserExpands.
        :rtype: UserConversationSummary
        """
        return self._conversation_summary

    @conversation_summary.setter
    def conversation_summary(self, conversation_summary: 'UserConversationSummary') -> None:
        """
        Sets the conversation_summary of this UserExpands.
        Summary of conversion statistics for conversation types.

        :param conversation_summary: The conversation_summary of this UserExpands.
        :type: UserConversationSummary
        """
        

        self._conversation_summary = conversation_summary

    @property
    def out_of_office(self) -> 'OutOfOffice':
        """
        Gets the out_of_office of this UserExpands.
        Determine if out of office is enabled

        :return: The out_of_office of this UserExpands.
        :rtype: OutOfOffice
        """
        return self._out_of_office

    @out_of_office.setter
    def out_of_office(self, out_of_office: 'OutOfOffice') -> None:
        """
        Sets the out_of_office of this UserExpands.
        Determine if out of office is enabled

        :param out_of_office: The out_of_office of this UserExpands.
        :type: OutOfOffice
        """
        

        self._out_of_office = out_of_office

    @property
    def geolocation(self) -> 'Geolocation':
        """
        Gets the geolocation of this UserExpands.
        Current geolocation position

        :return: The geolocation of this UserExpands.
        :rtype: Geolocation
        """
        return self._geolocation

    @geolocation.setter
    def geolocation(self, geolocation: 'Geolocation') -> None:
        """
        Sets the geolocation of this UserExpands.
        Current geolocation position

        :param geolocation: The geolocation of this UserExpands.
        :type: Geolocation
        """
        

        self._geolocation = geolocation

    @property
    def station(self) -> 'UserStations':
        """
        Gets the station of this UserExpands.
        Effective, default, and last station information

        :return: The station of this UserExpands.
        :rtype: UserStations
        """
        return self._station

    @station.setter
    def station(self, station: 'UserStations') -> None:
        """
        Sets the station of this UserExpands.
        Effective, default, and last station information

        :param station: The station of this UserExpands.
        :type: UserStations
        """
        

        self._station = station

    @property
    def authorization(self) -> 'UserAuthorization':
        """
        Gets the authorization of this UserExpands.
        Roles and permissions assigned to the user

        :return: The authorization of this UserExpands.
        :rtype: UserAuthorization
        """
        return self._authorization

    @authorization.setter
    def authorization(self, authorization: 'UserAuthorization') -> None:
        """
        Sets the authorization of this UserExpands.
        Roles and permissions assigned to the user

        :param authorization: The authorization of this UserExpands.
        :type: UserAuthorization
        """
        

        self._authorization = authorization

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

