# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import UserExpands

class UserProfile(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        UserProfile - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'state': 'str',
            'date_modified': 'datetime',
            'version': 'int',
            'expands': 'UserExpands',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'state': 'state',
            'date_modified': 'dateModified',
            'version': 'version',
            'expands': 'expands',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._state = None
        self._date_modified = None
        self._version = None
        self._expands = None
        self._self_uri = None

    @property
    def id(self) -> str:
        """
        Gets the id of this UserProfile.
        The globally unique identifier for the object.

        :return: The id of this UserProfile.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this UserProfile.
        The globally unique identifier for the object.

        :param id: The id of this UserProfile.
        :type: str
        """
        

        self._id = id

    @property
    def name(self) -> str:
        """
        Gets the name of this UserProfile.


        :return: The name of this UserProfile.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str) -> None:
        """
        Sets the name of this UserProfile.


        :param name: The name of this UserProfile.
        :type: str
        """
        

        self._name = name

    @property
    def state(self) -> str:
        """
        Gets the state of this UserProfile.
        The state of the user resource

        :return: The state of this UserProfile.
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state: str) -> None:
        """
        Sets the state of this UserProfile.
        The state of the user resource

        :param state: The state of this UserProfile.
        :type: str
        """
        if isinstance(state, int):
            state = str(state)
        allowed_values = ["active", "inactive", "deleted"]
        if state.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for state -> " + state)
            self._state = "outdated_sdk_version"
        else:
            self._state = state

    @property
    def date_modified(self) -> datetime:
        """
        Gets the date_modified of this UserProfile.
        Datetime of the last modification. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_modified of this UserProfile.
        :rtype: datetime
        """
        return self._date_modified

    @date_modified.setter
    def date_modified(self, date_modified: datetime) -> None:
        """
        Sets the date_modified of this UserProfile.
        Datetime of the last modification. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_modified: The date_modified of this UserProfile.
        :type: datetime
        """
        

        self._date_modified = date_modified

    @property
    def version(self) -> int:
        """
        Gets the version of this UserProfile.
        The version of the group resource

        :return: The version of this UserProfile.
        :rtype: int
        """
        return self._version

    @version.setter
    def version(self, version: int) -> None:
        """
        Sets the version of this UserProfile.
        The version of the group resource

        :param version: The version of this UserProfile.
        :type: int
        """
        

        self._version = version

    @property
    def expands(self) -> 'UserExpands':
        """
        Gets the expands of this UserProfile.
        User information expansions

        :return: The expands of this UserProfile.
        :rtype: UserExpands
        """
        return self._expands

    @expands.setter
    def expands(self, expands: 'UserExpands') -> None:
        """
        Sets the expands of this UserProfile.
        User information expansions

        :param expands: The expands of this UserProfile.
        :type: UserExpands
        """
        

        self._expands = expands

    @property
    def self_uri(self) -> str:
        """
        Gets the self_uri of this UserProfile.
        The URI for this object

        :return: The self_uri of this UserProfile.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri: str) -> None:
        """
        Sets the self_uri of this UserProfile.
        The URI for this object

        :param self_uri: The self_uri of this UserProfile.
        :type: str
        """
        

        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

