# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import MobileSettings

class UserSettingsForChat(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        UserSettingsForChat - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'muted': 'bool',
            'mentions_only': 'bool',
            'notify_on_reactions': 'bool',
            'mobile': 'MobileSettings'
        }

        self.attribute_map = {
            'muted': 'muted',
            'mentions_only': 'mentionsOnly',
            'notify_on_reactions': 'notifyOnReactions',
            'mobile': 'mobile'
        }

        self._muted = None
        self._mentions_only = None
        self._notify_on_reactions = None
        self._mobile = None

    @property
    def muted(self) -> bool:
        """
        Gets the muted of this UserSettingsForChat.
        Whether or not to enable muting notifications

        :return: The muted of this UserSettingsForChat.
        :rtype: bool
        """
        return self._muted

    @muted.setter
    def muted(self, muted: bool) -> None:
        """
        Sets the muted of this UserSettingsForChat.
        Whether or not to enable muting notifications

        :param muted: The muted of this UserSettingsForChat.
        :type: bool
        """
        

        self._muted = muted

    @property
    def mentions_only(self) -> bool:
        """
        Gets the mentions_only of this UserSettingsForChat.
        Whether or not to enable notifications for mentions only

        :return: The mentions_only of this UserSettingsForChat.
        :rtype: bool
        """
        return self._mentions_only

    @mentions_only.setter
    def mentions_only(self, mentions_only: bool) -> None:
        """
        Sets the mentions_only of this UserSettingsForChat.
        Whether or not to enable notifications for mentions only

        :param mentions_only: The mentions_only of this UserSettingsForChat.
        :type: bool
        """
        

        self._mentions_only = mentions_only

    @property
    def notify_on_reactions(self) -> bool:
        """
        Gets the notify_on_reactions of this UserSettingsForChat.
        Whether or not to enable notifications for reactions on a user's own messages

        :return: The notify_on_reactions of this UserSettingsForChat.
        :rtype: bool
        """
        return self._notify_on_reactions

    @notify_on_reactions.setter
    def notify_on_reactions(self, notify_on_reactions: bool) -> None:
        """
        Sets the notify_on_reactions of this UserSettingsForChat.
        Whether or not to enable notifications for reactions on a user's own messages

        :param notify_on_reactions: The notify_on_reactions of this UserSettingsForChat.
        :type: bool
        """
        

        self._notify_on_reactions = notify_on_reactions

    @property
    def mobile(self) -> 'MobileSettings':
        """
        Gets the mobile of this UserSettingsForChat.
        Settings for mobile devices

        :return: The mobile of this UserSettingsForChat.
        :rtype: MobileSettings
        """
        return self._mobile

    @mobile.setter
    def mobile(self, mobile: 'MobileSettings') -> None:
        """
        Sets the mobile of this UserSettingsForChat.
        Settings for mobile devices

        :param mobile: The mobile of this UserSettingsForChat.
        :type: MobileSettings
        """
        

        self._mobile = mobile

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

