# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import UserStation

class UserStations(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        UserStations - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'associated_station': 'UserStation',
            'effective_station': 'UserStation',
            'default_station': 'UserStation',
            'last_associated_station': 'UserStation'
        }

        self.attribute_map = {
            'associated_station': 'associatedStation',
            'effective_station': 'effectiveStation',
            'default_station': 'defaultStation',
            'last_associated_station': 'lastAssociatedStation'
        }

        self._associated_station = None
        self._effective_station = None
        self._default_station = None
        self._last_associated_station = None

    @property
    def associated_station(self) -> 'UserStation':
        """
        Gets the associated_station of this UserStations.
        Current associated station for this user.

        :return: The associated_station of this UserStations.
        :rtype: UserStation
        """
        return self._associated_station

    @associated_station.setter
    def associated_station(self, associated_station: 'UserStation') -> None:
        """
        Sets the associated_station of this UserStations.
        Current associated station for this user.

        :param associated_station: The associated_station of this UserStations.
        :type: UserStation
        """
        

        self._associated_station = associated_station

    @property
    def effective_station(self) -> 'UserStation':
        """
        Gets the effective_station of this UserStations.
        The station where the user can be reached based on their default and associated station.

        :return: The effective_station of this UserStations.
        :rtype: UserStation
        """
        return self._effective_station

    @effective_station.setter
    def effective_station(self, effective_station: 'UserStation') -> None:
        """
        Sets the effective_station of this UserStations.
        The station where the user can be reached based on their default and associated station.

        :param effective_station: The effective_station of this UserStations.
        :type: UserStation
        """
        

        self._effective_station = effective_station

    @property
    def default_station(self) -> 'UserStation':
        """
        Gets the default_station of this UserStations.
        Default station to be used if not associated with a station.

        :return: The default_station of this UserStations.
        :rtype: UserStation
        """
        return self._default_station

    @default_station.setter
    def default_station(self, default_station: 'UserStation') -> None:
        """
        Sets the default_station of this UserStations.
        Default station to be used if not associated with a station.

        :param default_station: The default_station of this UserStations.
        :type: UserStation
        """
        

        self._default_station = default_station

    @property
    def last_associated_station(self) -> 'UserStation':
        """
        Gets the last_associated_station of this UserStations.
        Last associated station for this user.

        :return: The last_associated_station of this UserStations.
        :rtype: UserStation
        """
        return self._last_associated_station

    @last_associated_station.setter
    def last_associated_station(self, last_associated_station: 'UserStation') -> None:
        """
        Sets the last_associated_station of this UserStations.
        Last associated station for this user.

        :param last_associated_station: The last_associated_station of this UserStations.
        :type: UserStation
        """
        

        self._last_associated_station = last_associated_station

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

