# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class UserTrendData(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        UserTrendData - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'date_start_workday': 'date',
            'date_end_workday': 'date',
            'percent_of_goal': 'float',
            'average_value': 'float',
            'rank_total_points': 'int',
            'rank_percentage_points': 'int'
        }

        self.attribute_map = {
            'date_start_workday': 'dateStartWorkday',
            'date_end_workday': 'dateEndWorkday',
            'percent_of_goal': 'percentOfGoal',
            'average_value': 'averageValue',
            'rank_total_points': 'rankTotalPoints',
            'rank_percentage_points': 'rankPercentagePoints'
        }

        self._date_start_workday = None
        self._date_end_workday = None
        self._percent_of_goal = None
        self._average_value = None
        self._rank_total_points = None
        self._rank_percentage_points = None

    @property
    def date_start_workday(self) -> date:
        """
        Gets the date_start_workday of this UserTrendData.
        Start workday used as the date range. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :return: The date_start_workday of this UserTrendData.
        :rtype: date
        """
        return self._date_start_workday

    @date_start_workday.setter
    def date_start_workday(self, date_start_workday: date) -> None:
        """
        Sets the date_start_workday of this UserTrendData.
        Start workday used as the date range. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :param date_start_workday: The date_start_workday of this UserTrendData.
        :type: date
        """
        

        self._date_start_workday = date_start_workday

    @property
    def date_end_workday(self) -> date:
        """
        Gets the date_end_workday of this UserTrendData.
        End workday used as the date range. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :return: The date_end_workday of this UserTrendData.
        :rtype: date
        """
        return self._date_end_workday

    @date_end_workday.setter
    def date_end_workday(self, date_end_workday: date) -> None:
        """
        Sets the date_end_workday of this UserTrendData.
        End workday used as the date range. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :param date_end_workday: The date_end_workday of this UserTrendData.
        :type: date
        """
        

        self._date_end_workday = date_end_workday

    @property
    def percent_of_goal(self) -> float:
        """
        Gets the percent_of_goal of this UserTrendData.
        Percent of goal

        :return: The percent_of_goal of this UserTrendData.
        :rtype: float
        """
        return self._percent_of_goal

    @percent_of_goal.setter
    def percent_of_goal(self, percent_of_goal: float) -> None:
        """
        Sets the percent_of_goal of this UserTrendData.
        Percent of goal

        :param percent_of_goal: The percent_of_goal of this UserTrendData.
        :type: float
        """
        

        self._percent_of_goal = percent_of_goal

    @property
    def average_value(self) -> float:
        """
        Gets the average_value of this UserTrendData.
        Average metric value

        :return: The average_value of this UserTrendData.
        :rtype: float
        """
        return self._average_value

    @average_value.setter
    def average_value(self, average_value: float) -> None:
        """
        Sets the average_value of this UserTrendData.
        Average metric value

        :param average_value: The average_value of this UserTrendData.
        :type: float
        """
        

        self._average_value = average_value

    @property
    def rank_total_points(self) -> int:
        """
        Gets the rank_total_points of this UserTrendData.
        Rank, ordered by total points

        :return: The rank_total_points of this UserTrendData.
        :rtype: int
        """
        return self._rank_total_points

    @rank_total_points.setter
    def rank_total_points(self, rank_total_points: int) -> None:
        """
        Sets the rank_total_points of this UserTrendData.
        Rank, ordered by total points

        :param rank_total_points: The rank_total_points of this UserTrendData.
        :type: int
        """
        

        self._rank_total_points = rank_total_points

    @property
    def rank_percentage_points(self) -> int:
        """
        Gets the rank_percentage_points of this UserTrendData.
        Rank, ordered by percentage of points

        :return: The rank_percentage_points of this UserTrendData.
        :rtype: int
        """
        return self._rank_percentage_points

    @rank_percentage_points.setter
    def rank_percentage_points(self, rank_percentage_points: int) -> None:
        """
        Sets the rank_percentage_points of this UserTrendData.
        Rank, ordered by percentage of points

        :param rank_percentage_points: The rank_percentage_points of this UserTrendData.
        :type: int
        """
        

        self._rank_percentage_points = rank_percentage_points

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

