# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import V2FlowExecutionDataFlowidTopicInvokingFlowContext
    from . import V2FlowExecutionDataFlowidTopicInvokingJourneyActionMapContext
    from . import V2FlowExecutionDataFlowidTopicInvokingProcessAutomationContext
    from . import V2FlowExecutionDataFlowidTopicInvokingQualityContext
    from . import V2FlowExecutionDataFlowidTopicInvokingWorkitemContext

class V2FlowExecutionDataFlowidTopicInvokingContextInfo(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        V2FlowExecutionDataFlowidTopicInvokingContextInfo - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'flow': 'V2FlowExecutionDataFlowidTopicInvokingFlowContext',
            'journey_action_map': 'V2FlowExecutionDataFlowidTopicInvokingJourneyActionMapContext',
            'process_automation': 'V2FlowExecutionDataFlowidTopicInvokingProcessAutomationContext',
            'quality': 'V2FlowExecutionDataFlowidTopicInvokingQualityContext',
            'workitem': 'V2FlowExecutionDataFlowidTopicInvokingWorkitemContext'
        }

        self.attribute_map = {
            'flow': 'flow',
            'journey_action_map': 'journeyActionMap',
            'process_automation': 'processAutomation',
            'quality': 'quality',
            'workitem': 'workitem'
        }

        self._flow = None
        self._journey_action_map = None
        self._process_automation = None
        self._quality = None
        self._workitem = None

    @property
    def flow(self) -> 'V2FlowExecutionDataFlowidTopicInvokingFlowContext':
        """
        Gets the flow of this V2FlowExecutionDataFlowidTopicInvokingContextInfo.


        :return: The flow of this V2FlowExecutionDataFlowidTopicInvokingContextInfo.
        :rtype: V2FlowExecutionDataFlowidTopicInvokingFlowContext
        """
        return self._flow

    @flow.setter
    def flow(self, flow: 'V2FlowExecutionDataFlowidTopicInvokingFlowContext') -> None:
        """
        Sets the flow of this V2FlowExecutionDataFlowidTopicInvokingContextInfo.


        :param flow: The flow of this V2FlowExecutionDataFlowidTopicInvokingContextInfo.
        :type: V2FlowExecutionDataFlowidTopicInvokingFlowContext
        """
        

        self._flow = flow

    @property
    def journey_action_map(self) -> 'V2FlowExecutionDataFlowidTopicInvokingJourneyActionMapContext':
        """
        Gets the journey_action_map of this V2FlowExecutionDataFlowidTopicInvokingContextInfo.


        :return: The journey_action_map of this V2FlowExecutionDataFlowidTopicInvokingContextInfo.
        :rtype: V2FlowExecutionDataFlowidTopicInvokingJourneyActionMapContext
        """
        return self._journey_action_map

    @journey_action_map.setter
    def journey_action_map(self, journey_action_map: 'V2FlowExecutionDataFlowidTopicInvokingJourneyActionMapContext') -> None:
        """
        Sets the journey_action_map of this V2FlowExecutionDataFlowidTopicInvokingContextInfo.


        :param journey_action_map: The journey_action_map of this V2FlowExecutionDataFlowidTopicInvokingContextInfo.
        :type: V2FlowExecutionDataFlowidTopicInvokingJourneyActionMapContext
        """
        

        self._journey_action_map = journey_action_map

    @property
    def process_automation(self) -> 'V2FlowExecutionDataFlowidTopicInvokingProcessAutomationContext':
        """
        Gets the process_automation of this V2FlowExecutionDataFlowidTopicInvokingContextInfo.


        :return: The process_automation of this V2FlowExecutionDataFlowidTopicInvokingContextInfo.
        :rtype: V2FlowExecutionDataFlowidTopicInvokingProcessAutomationContext
        """
        return self._process_automation

    @process_automation.setter
    def process_automation(self, process_automation: 'V2FlowExecutionDataFlowidTopicInvokingProcessAutomationContext') -> None:
        """
        Sets the process_automation of this V2FlowExecutionDataFlowidTopicInvokingContextInfo.


        :param process_automation: The process_automation of this V2FlowExecutionDataFlowidTopicInvokingContextInfo.
        :type: V2FlowExecutionDataFlowidTopicInvokingProcessAutomationContext
        """
        

        self._process_automation = process_automation

    @property
    def quality(self) -> 'V2FlowExecutionDataFlowidTopicInvokingQualityContext':
        """
        Gets the quality of this V2FlowExecutionDataFlowidTopicInvokingContextInfo.


        :return: The quality of this V2FlowExecutionDataFlowidTopicInvokingContextInfo.
        :rtype: V2FlowExecutionDataFlowidTopicInvokingQualityContext
        """
        return self._quality

    @quality.setter
    def quality(self, quality: 'V2FlowExecutionDataFlowidTopicInvokingQualityContext') -> None:
        """
        Sets the quality of this V2FlowExecutionDataFlowidTopicInvokingContextInfo.


        :param quality: The quality of this V2FlowExecutionDataFlowidTopicInvokingContextInfo.
        :type: V2FlowExecutionDataFlowidTopicInvokingQualityContext
        """
        

        self._quality = quality

    @property
    def workitem(self) -> 'V2FlowExecutionDataFlowidTopicInvokingWorkitemContext':
        """
        Gets the workitem of this V2FlowExecutionDataFlowidTopicInvokingContextInfo.


        :return: The workitem of this V2FlowExecutionDataFlowidTopicInvokingContextInfo.
        :rtype: V2FlowExecutionDataFlowidTopicInvokingWorkitemContext
        """
        return self._workitem

    @workitem.setter
    def workitem(self, workitem: 'V2FlowExecutionDataFlowidTopicInvokingWorkitemContext') -> None:
        """
        Sets the workitem of this V2FlowExecutionDataFlowidTopicInvokingContextInfo.


        :param workitem: The workitem of this V2FlowExecutionDataFlowidTopicInvokingContextInfo.
        :type: V2FlowExecutionDataFlowidTopicInvokingWorkitemContext
        """
        

        self._workitem = workitem

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

