# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import V2QueueObservationMetricStats
    from . import V2QueueObservationObservation

class V2QueueObservationMetricData(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        V2QueueObservationMetricData - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'metric': 'str',
            'observations': 'list[V2QueueObservationObservation]',
            'truncated': 'bool',
            'stats': 'V2QueueObservationMetricStats'
        }

        self.attribute_map = {
            'metric': 'metric',
            'observations': 'observations',
            'truncated': 'truncated',
            'stats': 'stats'
        }

        self._metric = None
        self._observations = None
        self._truncated = None
        self._stats = None

    @property
    def metric(self) -> str:
        """
        Gets the metric of this V2QueueObservationMetricData.
        The observation metric

        :return: The metric of this V2QueueObservationMetricData.
        :rtype: str
        """
        return self._metric

    @metric.setter
    def metric(self, metric: str) -> None:
        """
        Sets the metric of this V2QueueObservationMetricData.
        The observation metric

        :param metric: The metric of this V2QueueObservationMetricData.
        :type: str
        """
        if isinstance(metric, int):
            metric = str(metric)
        allowed_values = ["oAlerting", "oInteracting", "oWaiting", "oFlow", "oLongestWaiting", "oLongestInteracting"]
        if metric.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for metric -> " + metric)
            self._metric = "outdated_sdk_version"
        else:
            self._metric = metric

    @property
    def observations(self) -> List['V2QueueObservationObservation']:
        """
        Gets the observations of this V2QueueObservationMetricData.
        List of observations sorted by timestamp in ascending order. This list may be truncated.

        :return: The observations of this V2QueueObservationMetricData.
        :rtype: list[V2QueueObservationObservation]
        """
        return self._observations

    @observations.setter
    def observations(self, observations: List['V2QueueObservationObservation']) -> None:
        """
        Sets the observations of this V2QueueObservationMetricData.
        List of observations sorted by timestamp in ascending order. This list may be truncated.

        :param observations: The observations of this V2QueueObservationMetricData.
        :type: list[V2QueueObservationObservation]
        """
        

        self._observations = observations

    @property
    def truncated(self) -> bool:
        """
        Gets the truncated of this V2QueueObservationMetricData.
        Flag indicating whether the list of observations was truncated or not

        :return: The truncated of this V2QueueObservationMetricData.
        :rtype: bool
        """
        return self._truncated

    @truncated.setter
    def truncated(self, truncated: bool) -> None:
        """
        Sets the truncated of this V2QueueObservationMetricData.
        Flag indicating whether the list of observations was truncated or not

        :param truncated: The truncated of this V2QueueObservationMetricData.
        :type: bool
        """
        

        self._truncated = truncated

    @property
    def stats(self) -> 'V2QueueObservationMetricStats':
        """
        Gets the stats of this V2QueueObservationMetricData.


        :return: The stats of this V2QueueObservationMetricData.
        :rtype: V2QueueObservationMetricStats
        """
        return self._stats

    @stats.setter
    def stats(self, stats: 'V2QueueObservationMetricStats') -> None:
        """
        Sets the stats of this V2QueueObservationMetricData.


        :param stats: The stats of this V2QueueObservationMetricData.
        :type: V2QueueObservationMetricStats
        """
        

        self._stats = stats

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

